/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.pricing.v0;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import software.amazon.spapi.models.pricing.v0.DetailedShippingTimeType;
import software.amazon.spapi.models.pricing.v0.MoneyType;
import software.amazon.spapi.models.pricing.v0.OfferCustomerType;
import software.amazon.spapi.models.pricing.v0.Points;
import software.amazon.spapi.models.pricing.v0.PrimeInformationType;
import software.amazon.spapi.models.pricing.v0.QuantityDiscountPriceType;
import software.amazon.spapi.models.pricing.v0.SellerFeedbackType;
import software.amazon.spapi.models.pricing.v0.ShipsFromType;

@Schema(description="Schema for an individual offer. Object in `OfferDetailList`.")
public class OfferDetail {
    @SerializedName(value="MyOffer")
    private Boolean myOffer = null;
    @SerializedName(value="offerType")
    private OfferCustomerType offerType = null;
    @SerializedName(value="SubCondition")
    private String subCondition = null;
    @SerializedName(value="SellerId")
    private String sellerId = null;
    @SerializedName(value="ConditionNotes")
    private String conditionNotes = null;
    @SerializedName(value="SellerFeedbackRating")
    private SellerFeedbackType sellerFeedbackRating = null;
    @SerializedName(value="ShippingTime")
    private DetailedShippingTimeType shippingTime = null;
    @SerializedName(value="ListingPrice")
    private MoneyType listingPrice = null;
    @SerializedName(value="quantityDiscountPrices")
    private List<QuantityDiscountPriceType> quantityDiscountPrices = null;
    @SerializedName(value="Points")
    private Points points = null;
    @SerializedName(value="Shipping")
    private MoneyType shipping = null;
    @SerializedName(value="ShipsFrom")
    private ShipsFromType shipsFrom = null;
    @SerializedName(value="IsFulfilledByAmazon")
    private Boolean isFulfilledByAmazon = null;
    @SerializedName(value="PrimeInformation")
    private PrimeInformationType primeInformation = null;
    @SerializedName(value="IsBuyBoxWinner")
    private Boolean isBuyBoxWinner = null;
    @SerializedName(value="IsFeaturedMerchant")
    private Boolean isFeaturedMerchant = null;

    public OfferDetail myOffer(Boolean myOffer) {
        this.myOffer = myOffer;
        return this;
    }

    @Schema(description="When true, this is the seller's offer.")
    public Boolean isMyOffer() {
        return this.myOffer;
    }

    public void setMyOffer(Boolean myOffer) {
        this.myOffer = myOffer;
    }

    public OfferDetail offerType(OfferCustomerType offerType) {
        this.offerType = offerType;
        return this;
    }

    @Schema(description="")
    public OfferCustomerType getOfferType() {
        return this.offerType;
    }

    public void setOfferType(OfferCustomerType offerType) {
        this.offerType = offerType;
    }

    public OfferDetail subCondition(String subCondition) {
        this.subCondition = subCondition;
        return this;
    }

    @Schema(required=true, description="The subcondition of the item. Subcondition values: New, Mint, Very Good, Good, Acceptable, Poor, Club, OEM, Warranty, Refurbished Warranty, Refurbished, Open Box, or Other.")
    public String getSubCondition() {
        return this.subCondition;
    }

    public void setSubCondition(String subCondition) {
        this.subCondition = subCondition;
    }

    public OfferDetail sellerId(String sellerId) {
        this.sellerId = sellerId;
        return this;
    }

    @Schema(description="The seller identifier for the offer.")
    public String getSellerId() {
        return this.sellerId;
    }

    public void setSellerId(String sellerId) {
        this.sellerId = sellerId;
    }

    public OfferDetail conditionNotes(String conditionNotes) {
        this.conditionNotes = conditionNotes;
        return this;
    }

    @Schema(description="Information about the condition of the item.")
    public String getConditionNotes() {
        return this.conditionNotes;
    }

    public void setConditionNotes(String conditionNotes) {
        this.conditionNotes = conditionNotes;
    }

    public OfferDetail sellerFeedbackRating(SellerFeedbackType sellerFeedbackRating) {
        this.sellerFeedbackRating = sellerFeedbackRating;
        return this;
    }

    @Schema(description="")
    public SellerFeedbackType getSellerFeedbackRating() {
        return this.sellerFeedbackRating;
    }

    public void setSellerFeedbackRating(SellerFeedbackType sellerFeedbackRating) {
        this.sellerFeedbackRating = sellerFeedbackRating;
    }

    public OfferDetail shippingTime(DetailedShippingTimeType shippingTime) {
        this.shippingTime = shippingTime;
        return this;
    }

    @Schema(required=true, description="")
    public DetailedShippingTimeType getShippingTime() {
        return this.shippingTime;
    }

    public void setShippingTime(DetailedShippingTimeType shippingTime) {
        this.shippingTime = shippingTime;
    }

    public OfferDetail listingPrice(MoneyType listingPrice) {
        this.listingPrice = listingPrice;
        return this;
    }

    @Schema(required=true, description="")
    public MoneyType getListingPrice() {
        return this.listingPrice;
    }

    public void setListingPrice(MoneyType listingPrice) {
        this.listingPrice = listingPrice;
    }

    public OfferDetail quantityDiscountPrices(List<QuantityDiscountPriceType> quantityDiscountPrices) {
        this.quantityDiscountPrices = quantityDiscountPrices;
        return this;
    }

    public OfferDetail addQuantityDiscountPricesItem(QuantityDiscountPriceType quantityDiscountPricesItem) {
        if (this.quantityDiscountPrices == null) {
            this.quantityDiscountPrices = new ArrayList<QuantityDiscountPriceType>();
        }
        this.quantityDiscountPrices.add(quantityDiscountPricesItem);
        return this;
    }

    @Schema(description="List of `QuantityDiscountPrice` that contains item's pricing information when buy in bulk.")
    public List<QuantityDiscountPriceType> getQuantityDiscountPrices() {
        return this.quantityDiscountPrices;
    }

    public void setQuantityDiscountPrices(List<QuantityDiscountPriceType> quantityDiscountPrices) {
        this.quantityDiscountPrices = quantityDiscountPrices;
    }

    public OfferDetail points(Points points) {
        this.points = points;
        return this;
    }

    @Schema(description="")
    public Points getPoints() {
        return this.points;
    }

    public void setPoints(Points points) {
        this.points = points;
    }

    public OfferDetail shipping(MoneyType shipping) {
        this.shipping = shipping;
        return this;
    }

    @Schema(required=true, description="")
    public MoneyType getShipping() {
        return this.shipping;
    }

    public void setShipping(MoneyType shipping) {
        this.shipping = shipping;
    }

    public OfferDetail shipsFrom(ShipsFromType shipsFrom) {
        this.shipsFrom = shipsFrom;
        return this;
    }

    @Schema(description="")
    public ShipsFromType getShipsFrom() {
        return this.shipsFrom;
    }

    public void setShipsFrom(ShipsFromType shipsFrom) {
        this.shipsFrom = shipsFrom;
    }

    public OfferDetail isFulfilledByAmazon(Boolean isFulfilledByAmazon) {
        this.isFulfilledByAmazon = isFulfilledByAmazon;
        return this;
    }

    @Schema(required=true, description="When true, the offer is fulfilled by Amazon.")
    public Boolean isIsFulfilledByAmazon() {
        return this.isFulfilledByAmazon;
    }

    public void setIsFulfilledByAmazon(Boolean isFulfilledByAmazon) {
        this.isFulfilledByAmazon = isFulfilledByAmazon;
    }

    public OfferDetail primeInformation(PrimeInformationType primeInformation) {
        this.primeInformation = primeInformation;
        return this;
    }

    @Schema(description="")
    public PrimeInformationType getPrimeInformation() {
        return this.primeInformation;
    }

    public void setPrimeInformation(PrimeInformationType primeInformation) {
        this.primeInformation = primeInformation;
    }

    public OfferDetail isBuyBoxWinner(Boolean isBuyBoxWinner) {
        this.isBuyBoxWinner = isBuyBoxWinner;
        return this;
    }

    @Schema(description="When true, the offer is currently in the Buy Box. There can be up to two Buy Box winners at any time per ASIN, one that is eligible for Prime and one that is not eligible for Prime.")
    public Boolean isIsBuyBoxWinner() {
        return this.isBuyBoxWinner;
    }

    public void setIsBuyBoxWinner(Boolean isBuyBoxWinner) {
        this.isBuyBoxWinner = isBuyBoxWinner;
    }

    public OfferDetail isFeaturedMerchant(Boolean isFeaturedMerchant) {
        this.isFeaturedMerchant = isFeaturedMerchant;
        return this;
    }

    @Schema(description="When true, the seller of the item is eligible to win the Buy Box.")
    public Boolean isIsFeaturedMerchant() {
        return this.isFeaturedMerchant;
    }

    public void setIsFeaturedMerchant(Boolean isFeaturedMerchant) {
        this.isFeaturedMerchant = isFeaturedMerchant;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OfferDetail offerDetail = (OfferDetail)o;
        return Objects.equals(this.myOffer, offerDetail.myOffer) && Objects.equals((Object)this.offerType, (Object)offerDetail.offerType) && Objects.equals(this.subCondition, offerDetail.subCondition) && Objects.equals(this.sellerId, offerDetail.sellerId) && Objects.equals(this.conditionNotes, offerDetail.conditionNotes) && Objects.equals(this.sellerFeedbackRating, offerDetail.sellerFeedbackRating) && Objects.equals(this.shippingTime, offerDetail.shippingTime) && Objects.equals(this.listingPrice, offerDetail.listingPrice) && Objects.equals(this.quantityDiscountPrices, offerDetail.quantityDiscountPrices) && Objects.equals(this.points, offerDetail.points) && Objects.equals(this.shipping, offerDetail.shipping) && Objects.equals(this.shipsFrom, offerDetail.shipsFrom) && Objects.equals(this.isFulfilledByAmazon, offerDetail.isFulfilledByAmazon) && Objects.equals(this.primeInformation, offerDetail.primeInformation) && Objects.equals(this.isBuyBoxWinner, offerDetail.isBuyBoxWinner) && Objects.equals(this.isFeaturedMerchant, offerDetail.isFeaturedMerchant);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.myOffer, this.offerType, this.subCondition, this.sellerId, this.conditionNotes, this.sellerFeedbackRating, this.shippingTime, this.listingPrice, this.quantityDiscountPrices, this.points, this.shipping, this.shipsFrom, this.isFulfilledByAmazon, this.primeInformation, this.isBuyBoxWinner, this.isFeaturedMerchant});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OfferDetail {\n");
        sb.append("    myOffer: ").append(this.toIndentedString(this.myOffer)).append("\n");
        sb.append("    offerType: ").append(this.toIndentedString((Object)this.offerType)).append("\n");
        sb.append("    subCondition: ").append(this.toIndentedString(this.subCondition)).append("\n");
        sb.append("    sellerId: ").append(this.toIndentedString(this.sellerId)).append("\n");
        sb.append("    conditionNotes: ").append(this.toIndentedString(this.conditionNotes)).append("\n");
        sb.append("    sellerFeedbackRating: ").append(this.toIndentedString(this.sellerFeedbackRating)).append("\n");
        sb.append("    shippingTime: ").append(this.toIndentedString(this.shippingTime)).append("\n");
        sb.append("    listingPrice: ").append(this.toIndentedString(this.listingPrice)).append("\n");
        sb.append("    quantityDiscountPrices: ").append(this.toIndentedString(this.quantityDiscountPrices)).append("\n");
        sb.append("    points: ").append(this.toIndentedString(this.points)).append("\n");
        sb.append("    shipping: ").append(this.toIndentedString(this.shipping)).append("\n");
        sb.append("    shipsFrom: ").append(this.toIndentedString(this.shipsFrom)).append("\n");
        sb.append("    isFulfilledByAmazon: ").append(this.toIndentedString(this.isFulfilledByAmazon)).append("\n");
        sb.append("    primeInformation: ").append(this.toIndentedString(this.primeInformation)).append("\n");
        sb.append("    isBuyBoxWinner: ").append(this.toIndentedString(this.isBuyBoxWinner)).append("\n");
        sb.append("    isFeaturedMerchant: ").append(this.toIndentedString(this.isFeaturedMerchant)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

