/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.pricing.v0;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import software.amazon.spapi.models.pricing.v0.ConditionType;
import software.amazon.spapi.models.pricing.v0.ItemIdentifier;
import software.amazon.spapi.models.pricing.v0.OfferDetailList;
import software.amazon.spapi.models.pricing.v0.Summary;

@Schema(description="The payload for the getListingOffers and getItemOffers operations.")
public class GetOffersResult {
    @SerializedName(value="MarketplaceID")
    private String marketplaceID = null;
    @SerializedName(value="ASIN")
    private String ASIN = null;
    @SerializedName(value="SKU")
    private String SKU = null;
    @SerializedName(value="ItemCondition")
    private ConditionType itemCondition = null;
    @SerializedName(value="status")
    private String status = null;
    @SerializedName(value="Identifier")
    private ItemIdentifier identifier = null;
    @SerializedName(value="Summary")
    private Summary summary = null;
    @SerializedName(value="Offers")
    private OfferDetailList offers = null;

    public GetOffersResult marketplaceID(String marketplaceID) {
        this.marketplaceID = marketplaceID;
        return this;
    }

    @Schema(required=true, description="A marketplace identifier.")
    public String getMarketplaceID() {
        return this.marketplaceID;
    }

    public void setMarketplaceID(String marketplaceID) {
        this.marketplaceID = marketplaceID;
    }

    public GetOffersResult ASIN(String ASIN) {
        this.ASIN = ASIN;
        return this;
    }

    @Schema(description="The Amazon Standard Identification Number (ASIN) of the item.")
    public String getASIN() {
        return this.ASIN;
    }

    public void setASIN(String ASIN) {
        this.ASIN = ASIN;
    }

    public GetOffersResult SKU(String SKU) {
        this.SKU = SKU;
        return this;
    }

    @Schema(description="The stock keeping unit (SKU) of the item.")
    public String getSKU() {
        return this.SKU;
    }

    public void setSKU(String SKU) {
        this.SKU = SKU;
    }

    public GetOffersResult itemCondition(ConditionType itemCondition) {
        this.itemCondition = itemCondition;
        return this;
    }

    @Schema(required=true, description="")
    public ConditionType getItemCondition() {
        return this.itemCondition;
    }

    public void setItemCondition(ConditionType itemCondition) {
        this.itemCondition = itemCondition;
    }

    public GetOffersResult status(String status) {
        this.status = status;
        return this;
    }

    @Schema(required=true, description="The status of the operation.")
    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public GetOffersResult identifier(ItemIdentifier identifier) {
        this.identifier = identifier;
        return this;
    }

    @Schema(required=true, description="")
    public ItemIdentifier getIdentifier() {
        return this.identifier;
    }

    public void setIdentifier(ItemIdentifier identifier) {
        this.identifier = identifier;
    }

    public GetOffersResult summary(Summary summary) {
        this.summary = summary;
        return this;
    }

    @Schema(required=true, description="")
    public Summary getSummary() {
        return this.summary;
    }

    public void setSummary(Summary summary) {
        this.summary = summary;
    }

    public GetOffersResult offers(OfferDetailList offers) {
        this.offers = offers;
        return this;
    }

    @Schema(required=true, description="")
    public OfferDetailList getOffers() {
        return this.offers;
    }

    public void setOffers(OfferDetailList offers) {
        this.offers = offers;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GetOffersResult getOffersResult = (GetOffersResult)o;
        return Objects.equals(this.marketplaceID, getOffersResult.marketplaceID) && Objects.equals(this.ASIN, getOffersResult.ASIN) && Objects.equals(this.SKU, getOffersResult.SKU) && Objects.equals((Object)this.itemCondition, (Object)getOffersResult.itemCondition) && Objects.equals(this.status, getOffersResult.status) && Objects.equals(this.identifier, getOffersResult.identifier) && Objects.equals(this.summary, getOffersResult.summary) && Objects.equals(this.offers, getOffersResult.offers);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.marketplaceID, this.ASIN, this.SKU, this.itemCondition, this.status, this.identifier, this.summary, this.offers});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class GetOffersResult {\n");
        sb.append("    marketplaceID: ").append(this.toIndentedString(this.marketplaceID)).append("\n");
        sb.append("    ASIN: ").append(this.toIndentedString(this.ASIN)).append("\n");
        sb.append("    SKU: ").append(this.toIndentedString(this.SKU)).append("\n");
        sb.append("    itemCondition: ").append(this.toIndentedString((Object)this.itemCondition)).append("\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("    identifier: ").append(this.toIndentedString(this.identifier)).append("\n");
        sb.append("    summary: ").append(this.toIndentedString(this.summary)).append("\n");
        sb.append("    offers: ").append(this.toIndentedString(this.offers)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

