/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.pricing.v0;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import software.amazon.spapi.models.pricing.v0.HttpMethod;
import software.amazon.spapi.models.pricing.v0.HttpRequestHeaders;

@Schema(description="Common properties of batch requests against individual APIs.")
public class BatchRequest {
    @SerializedName(value="uri")
    private String uri = null;
    @SerializedName(value="method")
    private HttpMethod method = null;
    @SerializedName(value="headers")
    private HttpRequestHeaders headers = null;

    public BatchRequest uri(String uri) {
        this.uri = uri;
        return this;
    }

    @Schema(required=true, description="The resource path of the operation you are calling in batch without any query parameters.  If you are calling `getItemOffersBatch`, supply the path of `getItemOffers`.  **Example:** `/products/pricing/v0/items/B000P6Q7MY/offers`  If you are calling `getListingOffersBatch`, supply the path of `getListingOffers`.  **Example:** `/products/pricing/v0/listings/B000P6Q7MY/offers`")
    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public BatchRequest method(HttpMethod method) {
        this.method = method;
        return this;
    }

    @Schema(required=true, description="")
    public HttpMethod getMethod() {
        return this.method;
    }

    public void setMethod(HttpMethod method) {
        this.method = method;
    }

    public BatchRequest headers(HttpRequestHeaders headers) {
        this.headers = headers;
        return this;
    }

    @Schema(description="")
    public HttpRequestHeaders getHeaders() {
        return this.headers;
    }

    public void setHeaders(HttpRequestHeaders headers) {
        this.headers = headers;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BatchRequest batchRequest = (BatchRequest)o;
        return Objects.equals(this.uri, batchRequest.uri) && Objects.equals((Object)this.method, (Object)batchRequest.method) && Objects.equals(this.headers, batchRequest.headers);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.uri, this.method, this.headers});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BatchRequest {\n");
        sb.append("    uri: ").append(this.toIndentedString(this.uri)).append("\n");
        sb.append("    method: ").append(this.toIndentedString((Object)this.method)).append("\n");
        sb.append("    headers: ").append(this.toIndentedString(this.headers)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

