/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.orders.v0;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
import java.util.Objects;
import software.amazon.spapi.models.orders.v0.SubstitutionOptionList;

@Schema(description="Substitution preferences for an order item.")
public class SubstitutionPreferences {
    @SerializedName(value="SubstitutionType")
    private SubstitutionTypeEnum substitutionType = null;
    @SerializedName(value="SubstitutionOptions")
    private SubstitutionOptionList substitutionOptions = null;

    public SubstitutionPreferences substitutionType(SubstitutionTypeEnum substitutionType) {
        this.substitutionType = substitutionType;
        return this;
    }

    @Schema(required=true, description="The type of substitution that these preferences represent.")
    public SubstitutionTypeEnum getSubstitutionType() {
        return this.substitutionType;
    }

    public void setSubstitutionType(SubstitutionTypeEnum substitutionType) {
        this.substitutionType = substitutionType;
    }

    public SubstitutionPreferences substitutionOptions(SubstitutionOptionList substitutionOptions) {
        this.substitutionOptions = substitutionOptions;
        return this;
    }

    @Schema(description="")
    public SubstitutionOptionList getSubstitutionOptions() {
        return this.substitutionOptions;
    }

    public void setSubstitutionOptions(SubstitutionOptionList substitutionOptions) {
        this.substitutionOptions = substitutionOptions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SubstitutionPreferences substitutionPreferences = (SubstitutionPreferences)o;
        return Objects.equals((Object)this.substitutionType, (Object)substitutionPreferences.substitutionType) && Objects.equals(this.substitutionOptions, substitutionPreferences.substitutionOptions);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.substitutionType, this.substitutionOptions});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SubstitutionPreferences {\n");
        sb.append("    substitutionType: ").append(this.toIndentedString((Object)this.substitutionType)).append("\n");
        sb.append("    substitutionOptions: ").append(this.toIndentedString(this.substitutionOptions)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum SubstitutionTypeEnum {
        CUSTOMER_PREFERENCE("CUSTOMER_PREFERENCE"),
        AMAZON_RECOMMENDED("AMAZON_RECOMMENDED"),
        DO_NOT_SUBSTITUTE("DO_NOT_SUBSTITUTE");

        private String value;

        private SubstitutionTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static SubstitutionTypeEnum fromValue(String input) {
            for (SubstitutionTypeEnum b : SubstitutionTypeEnum.values()) {
                if (!b.value.equals(input)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<SubstitutionTypeEnum> {
            public void write(JsonWriter jsonWriter, SubstitutionTypeEnum enumeration) throws IOException {
                jsonWriter.value(String.valueOf(enumeration.getValue()));
            }

            public SubstitutionTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return SubstitutionTypeEnum.fromValue(value);
            }
        }
    }
}

