/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.orders.v0;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import org.threeten.bp.OffsetDateTime;
import software.amazon.spapi.models.orders.v0.ConfirmShipmentOrderItemsList;

@Schema(description="Properties of packages")
public class PackageDetail {
    @SerializedName(value="packageReferenceId")
    private String packageReferenceId = null;
    @SerializedName(value="carrierCode")
    private String carrierCode = null;
    @SerializedName(value="carrierName")
    private String carrierName = null;
    @SerializedName(value="shippingMethod")
    private String shippingMethod = null;
    @SerializedName(value="trackingNumber")
    private String trackingNumber = null;
    @SerializedName(value="shipDate")
    private OffsetDateTime shipDate = null;
    @SerializedName(value="shipFromSupplySourceId")
    private String shipFromSupplySourceId = null;
    @SerializedName(value="orderItems")
    private ConfirmShipmentOrderItemsList orderItems = null;

    public PackageDetail packageReferenceId(String packageReferenceId) {
        this.packageReferenceId = packageReferenceId;
        return this;
    }

    @Schema(required=true, description="")
    public String getPackageReferenceId() {
        return this.packageReferenceId;
    }

    public void setPackageReferenceId(String packageReferenceId) {
        this.packageReferenceId = packageReferenceId;
    }

    public PackageDetail carrierCode(String carrierCode) {
        this.carrierCode = carrierCode;
        return this;
    }

    @Schema(required=true, description="Identifies the carrier that will deliver the package. This field is required for all marketplaces. For more information, refer to the [`CarrierCode` announcement](https://developer-docs.amazon.com/sp-api/changelog/carriercode-value-required-in-shipment-confirmations-for-br-mx-ca-sg-au-in-jp-marketplaces).")
    public String getCarrierCode() {
        return this.carrierCode;
    }

    public void setCarrierCode(String carrierCode) {
        this.carrierCode = carrierCode;
    }

    public PackageDetail carrierName(String carrierName) {
        this.carrierName = carrierName;
        return this;
    }

    @Schema(description="Carrier name that will deliver the package. Required when `carrierCode` is \"Other\" ")
    public String getCarrierName() {
        return this.carrierName;
    }

    public void setCarrierName(String carrierName) {
        this.carrierName = carrierName;
    }

    public PackageDetail shippingMethod(String shippingMethod) {
        this.shippingMethod = shippingMethod;
        return this;
    }

    @Schema(description="Ship method to be used for shipping the order.")
    public String getShippingMethod() {
        return this.shippingMethod;
    }

    public void setShippingMethod(String shippingMethod) {
        this.shippingMethod = shippingMethod;
    }

    public PackageDetail trackingNumber(String trackingNumber) {
        this.trackingNumber = trackingNumber;
        return this;
    }

    @Schema(required=true, description="The tracking number used to obtain tracking and delivery information.")
    public String getTrackingNumber() {
        return this.trackingNumber;
    }

    public void setTrackingNumber(String trackingNumber) {
        this.trackingNumber = trackingNumber;
    }

    public PackageDetail shipDate(OffsetDateTime shipDate) {
        this.shipDate = shipDate;
        return this;
    }

    @Schema(required=true, description="The shipping date for the package. Must be in <a href='https://developer-docs.amazon.com/sp-api/docs/iso-8601'>ISO 8601</a> date/time format.")
    public OffsetDateTime getShipDate() {
        return this.shipDate;
    }

    public void setShipDate(OffsetDateTime shipDate) {
        this.shipDate = shipDate;
    }

    public PackageDetail shipFromSupplySourceId(String shipFromSupplySourceId) {
        this.shipFromSupplySourceId = shipFromSupplySourceId;
        return this;
    }

    @Schema(description="The unique identifier for the supply source.")
    public String getShipFromSupplySourceId() {
        return this.shipFromSupplySourceId;
    }

    public void setShipFromSupplySourceId(String shipFromSupplySourceId) {
        this.shipFromSupplySourceId = shipFromSupplySourceId;
    }

    public PackageDetail orderItems(ConfirmShipmentOrderItemsList orderItems) {
        this.orderItems = orderItems;
        return this;
    }

    @Schema(required=true, description="")
    public ConfirmShipmentOrderItemsList getOrderItems() {
        return this.orderItems;
    }

    public void setOrderItems(ConfirmShipmentOrderItemsList orderItems) {
        this.orderItems = orderItems;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PackageDetail packageDetail = (PackageDetail)o;
        return Objects.equals(this.packageReferenceId, packageDetail.packageReferenceId) && Objects.equals(this.carrierCode, packageDetail.carrierCode) && Objects.equals(this.carrierName, packageDetail.carrierName) && Objects.equals(this.shippingMethod, packageDetail.shippingMethod) && Objects.equals(this.trackingNumber, packageDetail.trackingNumber) && Objects.equals(this.shipDate, packageDetail.shipDate) && Objects.equals(this.shipFromSupplySourceId, packageDetail.shipFromSupplySourceId) && Objects.equals(this.orderItems, packageDetail.orderItems);
    }

    public int hashCode() {
        return Objects.hash(this.packageReferenceId, this.carrierCode, this.carrierName, this.shippingMethod, this.trackingNumber, this.shipDate, this.shipFromSupplySourceId, this.orderItems);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PackageDetail {\n");
        sb.append("    packageReferenceId: ").append(this.toIndentedString(this.packageReferenceId)).append("\n");
        sb.append("    carrierCode: ").append(this.toIndentedString(this.carrierCode)).append("\n");
        sb.append("    carrierName: ").append(this.toIndentedString(this.carrierName)).append("\n");
        sb.append("    shippingMethod: ").append(this.toIndentedString(this.shippingMethod)).append("\n");
        sb.append("    trackingNumber: ").append(this.toIndentedString(this.trackingNumber)).append("\n");
        sb.append("    shipDate: ").append(this.toIndentedString(this.shipDate)).append("\n");
        sb.append("    shipFromSupplySourceId: ").append(this.toIndentedString(this.shipFromSupplySourceId)).append("\n");
        sb.append("    orderItems: ").append(this.toIndentedString(this.orderItems)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

