/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.orders.v0;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import software.amazon.spapi.models.orders.v0.OrderList;

@Schema(description="A list of orders along with additional information to make subsequent API calls.")
public class OrdersList {
    @SerializedName(value="Orders")
    private OrderList orders = null;
    @SerializedName(value="NextToken")
    private String nextToken = null;
    @SerializedName(value="LastUpdatedBefore")
    private String lastUpdatedBefore = null;
    @SerializedName(value="CreatedBefore")
    private String createdBefore = null;

    public OrdersList orders(OrderList orders) {
        this.orders = orders;
        return this;
    }

    @Schema(required=true, description="")
    public OrderList getOrders() {
        return this.orders;
    }

    public void setOrders(OrderList orders) {
        this.orders = orders;
    }

    public OrdersList nextToken(String nextToken) {
        this.nextToken = nextToken;
        return this;
    }

    @Schema(description="When present and not empty, pass this string token in the next request to return the next response page.")
    public String getNextToken() {
        return this.nextToken;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public OrdersList lastUpdatedBefore(String lastUpdatedBefore) {
        this.lastUpdatedBefore = lastUpdatedBefore;
        return this;
    }

    @Schema(description="Use this date to select orders that were last updated before (or at) a specified time. An update is defined as any change in order status, including the creation of a new order. Includes updates made by Amazon and by the seller. Use [ISO 8601](https://developer-docs.amazon.com/sp-api/docs/iso-8601) format for all dates.")
    public String getLastUpdatedBefore() {
        return this.lastUpdatedBefore;
    }

    public void setLastUpdatedBefore(String lastUpdatedBefore) {
        this.lastUpdatedBefore = lastUpdatedBefore;
    }

    public OrdersList createdBefore(String createdBefore) {
        this.createdBefore = createdBefore;
        return this;
    }

    @Schema(description="Use this date to select orders created before (or at) a specified time. Only orders placed before the specified time are returned. The date must be in [ISO 8601](https://developer-docs.amazon.com/sp-api/docs/iso-8601) format.")
    public String getCreatedBefore() {
        return this.createdBefore;
    }

    public void setCreatedBefore(String createdBefore) {
        this.createdBefore = createdBefore;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OrdersList ordersList = (OrdersList)o;
        return Objects.equals(this.orders, ordersList.orders) && Objects.equals(this.nextToken, ordersList.nextToken) && Objects.equals(this.lastUpdatedBefore, ordersList.lastUpdatedBefore) && Objects.equals(this.createdBefore, ordersList.createdBefore);
    }

    public int hashCode() {
        return Objects.hash(this.orders, this.nextToken, this.lastUpdatedBefore, this.createdBefore);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OrdersList {\n");
        sb.append("    orders: ").append(this.toIndentedString(this.orders)).append("\n");
        sb.append("    nextToken: ").append(this.toIndentedString(this.nextToken)).append("\n");
        sb.append("    lastUpdatedBefore: ").append(this.toIndentedString(this.lastUpdatedBefore)).append("\n");
        sb.append("    createdBefore: ").append(this.toIndentedString(this.createdBefore)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

