/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.orders.v0;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import software.amazon.spapi.models.orders.v0.OrderItemList;

@Schema(description="The order items list along with the order ID.")
public class OrderItemsList {
    @SerializedName(value="OrderItems")
    private OrderItemList orderItems = null;
    @SerializedName(value="NextToken")
    private String nextToken = null;
    @SerializedName(value="AmazonOrderId")
    private String amazonOrderId = null;

    public OrderItemsList orderItems(OrderItemList orderItems) {
        this.orderItems = orderItems;
        return this;
    }

    @Schema(required=true, description="")
    public OrderItemList getOrderItems() {
        return this.orderItems;
    }

    public void setOrderItems(OrderItemList orderItems) {
        this.orderItems = orderItems;
    }

    public OrderItemsList nextToken(String nextToken) {
        this.nextToken = nextToken;
        return this;
    }

    @Schema(description="When present and not empty, pass this string token in the next request to return the next response page.")
    public String getNextToken() {
        return this.nextToken;
    }

    public void setNextToken(String nextToken) {
        this.nextToken = nextToken;
    }

    public OrderItemsList amazonOrderId(String amazonOrderId) {
        this.amazonOrderId = amazonOrderId;
        return this;
    }

    @Schema(required=true, description="An Amazon-defined order identifier, in 3-7-7 format.")
    public String getAmazonOrderId() {
        return this.amazonOrderId;
    }

    public void setAmazonOrderId(String amazonOrderId) {
        this.amazonOrderId = amazonOrderId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OrderItemsList orderItemsList = (OrderItemsList)o;
        return Objects.equals(this.orderItems, orderItemsList.orderItems) && Objects.equals(this.nextToken, orderItemsList.nextToken) && Objects.equals(this.amazonOrderId, orderItemsList.amazonOrderId);
    }

    public int hashCode() {
        return Objects.hash(this.orderItems, this.nextToken, this.amazonOrderId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OrderItemsList {\n");
        sb.append("    orderItems: ").append(this.toIndentedString(this.orderItems)).append("\n");
        sb.append("    nextToken: ").append(this.toIndentedString(this.nextToken)).append("\n");
        sb.append("    amazonOrderId: ").append(this.toIndentedString(this.amazonOrderId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

