/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.orders.v0;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import software.amazon.spapi.models.orders.v0.BuyerCustomizedInfoDetail;
import software.amazon.spapi.models.orders.v0.Money;

@Schema(description="A single order item's buyer information.")
public class OrderItemBuyerInfo {
    @SerializedName(value="OrderItemId")
    private String orderItemId = null;
    @SerializedName(value="BuyerCustomizedInfo")
    private BuyerCustomizedInfoDetail buyerCustomizedInfo = null;
    @SerializedName(value="GiftWrapPrice")
    private Money giftWrapPrice = null;
    @SerializedName(value="GiftWrapTax")
    private Money giftWrapTax = null;
    @SerializedName(value="GiftMessageText")
    private String giftMessageText = null;
    @SerializedName(value="GiftWrapLevel")
    private String giftWrapLevel = null;

    public OrderItemBuyerInfo orderItemId(String orderItemId) {
        this.orderItemId = orderItemId;
        return this;
    }

    @Schema(required=true, description="An Amazon-defined order item identifier.")
    public String getOrderItemId() {
        return this.orderItemId;
    }

    public void setOrderItemId(String orderItemId) {
        this.orderItemId = orderItemId;
    }

    public OrderItemBuyerInfo buyerCustomizedInfo(BuyerCustomizedInfoDetail buyerCustomizedInfo) {
        this.buyerCustomizedInfo = buyerCustomizedInfo;
        return this;
    }

    @Schema(description="")
    public BuyerCustomizedInfoDetail getBuyerCustomizedInfo() {
        return this.buyerCustomizedInfo;
    }

    public void setBuyerCustomizedInfo(BuyerCustomizedInfoDetail buyerCustomizedInfo) {
        this.buyerCustomizedInfo = buyerCustomizedInfo;
    }

    public OrderItemBuyerInfo giftWrapPrice(Money giftWrapPrice) {
        this.giftWrapPrice = giftWrapPrice;
        return this;
    }

    @Schema(description="")
    public Money getGiftWrapPrice() {
        return this.giftWrapPrice;
    }

    public void setGiftWrapPrice(Money giftWrapPrice) {
        this.giftWrapPrice = giftWrapPrice;
    }

    public OrderItemBuyerInfo giftWrapTax(Money giftWrapTax) {
        this.giftWrapTax = giftWrapTax;
        return this;
    }

    @Schema(description="")
    public Money getGiftWrapTax() {
        return this.giftWrapTax;
    }

    public void setGiftWrapTax(Money giftWrapTax) {
        this.giftWrapTax = giftWrapTax;
    }

    public OrderItemBuyerInfo giftMessageText(String giftMessageText) {
        this.giftMessageText = giftMessageText;
        return this;
    }

    @Schema(description="A gift message provided by the buyer.  **Note**: This attribute is only available for MFN (fulfilled by seller) orders.")
    public String getGiftMessageText() {
        return this.giftMessageText;
    }

    public void setGiftMessageText(String giftMessageText) {
        this.giftMessageText = giftMessageText;
    }

    public OrderItemBuyerInfo giftWrapLevel(String giftWrapLevel) {
        this.giftWrapLevel = giftWrapLevel;
        return this;
    }

    @Schema(description="The gift wrap level specified by the buyer.")
    public String getGiftWrapLevel() {
        return this.giftWrapLevel;
    }

    public void setGiftWrapLevel(String giftWrapLevel) {
        this.giftWrapLevel = giftWrapLevel;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OrderItemBuyerInfo orderItemBuyerInfo = (OrderItemBuyerInfo)o;
        return Objects.equals(this.orderItemId, orderItemBuyerInfo.orderItemId) && Objects.equals(this.buyerCustomizedInfo, orderItemBuyerInfo.buyerCustomizedInfo) && Objects.equals(this.giftWrapPrice, orderItemBuyerInfo.giftWrapPrice) && Objects.equals(this.giftWrapTax, orderItemBuyerInfo.giftWrapTax) && Objects.equals(this.giftMessageText, orderItemBuyerInfo.giftMessageText) && Objects.equals(this.giftWrapLevel, orderItemBuyerInfo.giftWrapLevel);
    }

    public int hashCode() {
        return Objects.hash(this.orderItemId, this.buyerCustomizedInfo, this.giftWrapPrice, this.giftWrapTax, this.giftMessageText, this.giftWrapLevel);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class OrderItemBuyerInfo {\n");
        sb.append("    orderItemId: ").append(this.toIndentedString(this.orderItemId)).append("\n");
        sb.append("    buyerCustomizedInfo: ").append(this.toIndentedString(this.buyerCustomizedInfo)).append("\n");
        sb.append("    giftWrapPrice: ").append(this.toIndentedString(this.giftWrapPrice)).append("\n");
        sb.append("    giftWrapTax: ").append(this.toIndentedString(this.giftWrapTax)).append("\n");
        sb.append("    giftMessageText: ").append(this.toIndentedString(this.giftMessageText)).append("\n");
        sb.append("    giftWrapLevel: ").append(this.toIndentedString(this.giftWrapLevel)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

