/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.orders.v0;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import software.amazon.spapi.models.orders.v0.OtherDeliveryAttributes;
import software.amazon.spapi.models.orders.v0.PreferredDeliveryTime;

@Schema(description="Contains all of the delivery instructions provided by the customer for the shipping address.")
public class DeliveryPreferences {
    @SerializedName(value="DropOffLocation")
    private String dropOffLocation = null;
    @SerializedName(value="PreferredDeliveryTime")
    private PreferredDeliveryTime preferredDeliveryTime = null;
    @SerializedName(value="OtherAttributes")
    private List<OtherDeliveryAttributes> otherAttributes = null;
    @SerializedName(value="AddressInstructions")
    private String addressInstructions = null;

    public DeliveryPreferences dropOffLocation(String dropOffLocation) {
        this.dropOffLocation = dropOffLocation;
        return this;
    }

    @Schema(description="Drop-off location selected by the customer.")
    public String getDropOffLocation() {
        return this.dropOffLocation;
    }

    public void setDropOffLocation(String dropOffLocation) {
        this.dropOffLocation = dropOffLocation;
    }

    public DeliveryPreferences preferredDeliveryTime(PreferredDeliveryTime preferredDeliveryTime) {
        this.preferredDeliveryTime = preferredDeliveryTime;
        return this;
    }

    @Schema(description="")
    public PreferredDeliveryTime getPreferredDeliveryTime() {
        return this.preferredDeliveryTime;
    }

    public void setPreferredDeliveryTime(PreferredDeliveryTime preferredDeliveryTime) {
        this.preferredDeliveryTime = preferredDeliveryTime;
    }

    public DeliveryPreferences otherAttributes(List<OtherDeliveryAttributes> otherAttributes) {
        this.otherAttributes = otherAttributes;
        return this;
    }

    public DeliveryPreferences addOtherAttributesItem(OtherDeliveryAttributes otherAttributesItem) {
        if (this.otherAttributes == null) {
            this.otherAttributes = new ArrayList<OtherDeliveryAttributes>();
        }
        this.otherAttributes.add(otherAttributesItem);
        return this;
    }

    @Schema(description="Enumerated list of miscellaneous delivery attributes associated with the shipping address.")
    public List<OtherDeliveryAttributes> getOtherAttributes() {
        return this.otherAttributes;
    }

    public void setOtherAttributes(List<OtherDeliveryAttributes> otherAttributes) {
        this.otherAttributes = otherAttributes;
    }

    public DeliveryPreferences addressInstructions(String addressInstructions) {
        this.addressInstructions = addressInstructions;
        return this;
    }

    @Schema(description="Building instructions, nearby landmark or navigation instructions.")
    public String getAddressInstructions() {
        return this.addressInstructions;
    }

    public void setAddressInstructions(String addressInstructions) {
        this.addressInstructions = addressInstructions;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeliveryPreferences deliveryPreferences = (DeliveryPreferences)o;
        return Objects.equals(this.dropOffLocation, deliveryPreferences.dropOffLocation) && Objects.equals(this.preferredDeliveryTime, deliveryPreferences.preferredDeliveryTime) && Objects.equals(this.otherAttributes, deliveryPreferences.otherAttributes) && Objects.equals(this.addressInstructions, deliveryPreferences.addressInstructions);
    }

    public int hashCode() {
        return Objects.hash(this.dropOffLocation, this.preferredDeliveryTime, this.otherAttributes, this.addressInstructions);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DeliveryPreferences {\n");
        sb.append("    dropOffLocation: ").append(this.toIndentedString(this.dropOffLocation)).append("\n");
        sb.append("    preferredDeliveryTime: ").append(this.toIndentedString(this.preferredDeliveryTime)).append("\n");
        sb.append("    otherAttributes: ").append(this.toIndentedString(this.otherAttributes)).append("\n");
        sb.append("    addressInstructions: ").append(this.toIndentedString(this.addressInstructions)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

