/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.orders.v0;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import software.amazon.spapi.models.orders.v0.OpenInterval;

@Schema(description="Business days and hours when the destination is open for deliveries.")
public class BusinessHours {
    @SerializedName(value="DayOfWeek")
    private DayOfWeekEnum dayOfWeek = null;
    @SerializedName(value="OpenIntervals")
    private List<OpenInterval> openIntervals = null;

    public BusinessHours dayOfWeek(DayOfWeekEnum dayOfWeek) {
        this.dayOfWeek = dayOfWeek;
        return this;
    }

    @Schema(description="Day of the week.")
    public DayOfWeekEnum getDayOfWeek() {
        return this.dayOfWeek;
    }

    public void setDayOfWeek(DayOfWeekEnum dayOfWeek) {
        this.dayOfWeek = dayOfWeek;
    }

    public BusinessHours openIntervals(List<OpenInterval> openIntervals) {
        this.openIntervals = openIntervals;
        return this;
    }

    public BusinessHours addOpenIntervalsItem(OpenInterval openIntervalsItem) {
        if (this.openIntervals == null) {
            this.openIntervals = new ArrayList<OpenInterval>();
        }
        this.openIntervals.add(openIntervalsItem);
        return this;
    }

    @Schema(description="Time window during the day when the business is open.")
    public List<OpenInterval> getOpenIntervals() {
        return this.openIntervals;
    }

    public void setOpenIntervals(List<OpenInterval> openIntervals) {
        this.openIntervals = openIntervals;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BusinessHours businessHours = (BusinessHours)o;
        return Objects.equals((Object)this.dayOfWeek, (Object)businessHours.dayOfWeek) && Objects.equals(this.openIntervals, businessHours.openIntervals);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.dayOfWeek, this.openIntervals});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class BusinessHours {\n");
        sb.append("    dayOfWeek: ").append(this.toIndentedString((Object)this.dayOfWeek)).append("\n");
        sb.append("    openIntervals: ").append(this.toIndentedString(this.openIntervals)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum DayOfWeekEnum {
        SUN("SUN"),
        MON("MON"),
        TUE("TUE"),
        WED("WED"),
        THU("THU"),
        FRI("FRI"),
        SAT("SAT");

        private String value;

        private DayOfWeekEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static DayOfWeekEnum fromValue(String input) {
            for (DayOfWeekEnum b : DayOfWeekEnum.values()) {
                if (!b.value.equals(input)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<DayOfWeekEnum> {
            public void write(JsonWriter jsonWriter, DayOfWeekEnum enumeration) throws IOException {
                jsonWriter.value(String.valueOf(enumeration.getValue()));
            }

            public DayOfWeekEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return DayOfWeekEnum.fromValue(value);
            }
        }
    }
}

