/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.notifications.v1;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import software.amazon.spapi.models.notifications.v1.DestinationResource;

@Schema(description="Information about the destination created when you call the `createDestination` operation.")
public class Destination {
    @SerializedName(value="name")
    private String name = null;
    @SerializedName(value="destinationId")
    private String destinationId = null;
    @SerializedName(value="resource")
    private DestinationResource resource = null;

    public Destination name(String name) {
        this.name = name;
        return this;
    }

    @Schema(required=true, description="The developer-defined name for this destination.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Destination destinationId(String destinationId) {
        this.destinationId = destinationId;
        return this;
    }

    @Schema(required=true, description="The destination identifier generated when you created the destination.")
    public String getDestinationId() {
        return this.destinationId;
    }

    public void setDestinationId(String destinationId) {
        this.destinationId = destinationId;
    }

    public Destination resource(DestinationResource resource) {
        this.resource = resource;
        return this;
    }

    @Schema(required=true, description="")
    public DestinationResource getResource() {
        return this.resource;
    }

    public void setResource(DestinationResource resource) {
        this.resource = resource;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Destination destination = (Destination)o;
        return Objects.equals(this.name, destination.name) && Objects.equals(this.destinationId, destination.destinationId) && Objects.equals(this.resource, destination.resource);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.destinationId, this.resource);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Destination {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    destinationId: ").append(this.toIndentedString(this.destinationId)).append("\n");
        sb.append("    resource: ").append(this.toIndentedString(this.resource)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

