/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.notifications.v1;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import software.amazon.spapi.models.notifications.v1.ProcessingDirective;

@Schema(description="The request schema for the `createSubscription` operation.")
public class CreateSubscriptionRequest {
    @SerializedName(value="payloadVersion")
    private String payloadVersion = null;
    @SerializedName(value="destinationId")
    private String destinationId = null;
    @SerializedName(value="processingDirective")
    private ProcessingDirective processingDirective = null;

    public CreateSubscriptionRequest payloadVersion(String payloadVersion) {
        this.payloadVersion = payloadVersion;
        return this;
    }

    @Schema(required=true, description="The version of the payload object to be used in the notification.")
    public String getPayloadVersion() {
        return this.payloadVersion;
    }

    public void setPayloadVersion(String payloadVersion) {
        this.payloadVersion = payloadVersion;
    }

    public CreateSubscriptionRequest destinationId(String destinationId) {
        this.destinationId = destinationId;
        return this;
    }

    @Schema(required=true, description="The identifier for the destination where notifications will be delivered.")
    public String getDestinationId() {
        return this.destinationId;
    }

    public void setDestinationId(String destinationId) {
        this.destinationId = destinationId;
    }

    public CreateSubscriptionRequest processingDirective(ProcessingDirective processingDirective) {
        this.processingDirective = processingDirective;
        return this;
    }

    @Schema(description="")
    public ProcessingDirective getProcessingDirective() {
        return this.processingDirective;
    }

    public void setProcessingDirective(ProcessingDirective processingDirective) {
        this.processingDirective = processingDirective;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateSubscriptionRequest createSubscriptionRequest = (CreateSubscriptionRequest)o;
        return Objects.equals(this.payloadVersion, createSubscriptionRequest.payloadVersion) && Objects.equals(this.destinationId, createSubscriptionRequest.destinationId) && Objects.equals(this.processingDirective, createSubscriptionRequest.processingDirective);
    }

    public int hashCode() {
        return Objects.hash(this.payloadVersion, this.destinationId, this.processingDirective);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class CreateSubscriptionRequest {\n");
        sb.append("    payloadVersion: ").append(this.toIndentedString(this.payloadVersion)).append("\n");
        sb.append("    destinationId: ").append(this.toIndentedString(this.destinationId)).append("\n");
        sb.append("    processingDirective: ").append(this.toIndentedString(this.processingDirective)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

