/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.merchantfulfillment.v0;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import org.threeten.bp.OffsetDateTime;
import software.amazon.spapi.models.merchantfulfillment.v0.Address;
import software.amazon.spapi.models.merchantfulfillment.v0.ItemList;
import software.amazon.spapi.models.merchantfulfillment.v0.LabelCustomization;
import software.amazon.spapi.models.merchantfulfillment.v0.PackageDimensions;
import software.amazon.spapi.models.merchantfulfillment.v0.ShippingServiceOptions;
import software.amazon.spapi.models.merchantfulfillment.v0.Weight;

@Schema(description="Shipment information required for requesting shipping service offers or for creating a shipment.")
public class ShipmentRequestDetails {
    @SerializedName(value="AmazonOrderId")
    private String amazonOrderId = null;
    @SerializedName(value="SellerOrderId")
    private String sellerOrderId = null;
    @SerializedName(value="ItemList")
    private ItemList itemList = null;
    @SerializedName(value="ShipFromAddress")
    private Address shipFromAddress = null;
    @SerializedName(value="PackageDimensions")
    private PackageDimensions packageDimensions = null;
    @SerializedName(value="Weight")
    private Weight weight = null;
    @SerializedName(value="MustArriveByDate")
    private OffsetDateTime mustArriveByDate = null;
    @SerializedName(value="ShipDate")
    private OffsetDateTime shipDate = null;
    @SerializedName(value="ShippingServiceOptions")
    private ShippingServiceOptions shippingServiceOptions = null;
    @SerializedName(value="LabelCustomization")
    private LabelCustomization labelCustomization = null;

    public ShipmentRequestDetails amazonOrderId(String amazonOrderId) {
        this.amazonOrderId = amazonOrderId;
        return this;
    }

    @Schema(required=true, description="")
    public String getAmazonOrderId() {
        return this.amazonOrderId;
    }

    public void setAmazonOrderId(String amazonOrderId) {
        this.amazonOrderId = amazonOrderId;
    }

    public ShipmentRequestDetails sellerOrderId(String sellerOrderId) {
        this.sellerOrderId = sellerOrderId;
        return this;
    }

    @Schema(description="")
    public String getSellerOrderId() {
        return this.sellerOrderId;
    }

    public void setSellerOrderId(String sellerOrderId) {
        this.sellerOrderId = sellerOrderId;
    }

    public ShipmentRequestDetails itemList(ItemList itemList) {
        this.itemList = itemList;
        return this;
    }

    @Schema(required=true, description="")
    public ItemList getItemList() {
        return this.itemList;
    }

    public void setItemList(ItemList itemList) {
        this.itemList = itemList;
    }

    public ShipmentRequestDetails shipFromAddress(Address shipFromAddress) {
        this.shipFromAddress = shipFromAddress;
        return this;
    }

    @Schema(required=true, description="")
    public Address getShipFromAddress() {
        return this.shipFromAddress;
    }

    public void setShipFromAddress(Address shipFromAddress) {
        this.shipFromAddress = shipFromAddress;
    }

    public ShipmentRequestDetails packageDimensions(PackageDimensions packageDimensions) {
        this.packageDimensions = packageDimensions;
        return this;
    }

    @Schema(required=true, description="")
    public PackageDimensions getPackageDimensions() {
        return this.packageDimensions;
    }

    public void setPackageDimensions(PackageDimensions packageDimensions) {
        this.packageDimensions = packageDimensions;
    }

    public ShipmentRequestDetails weight(Weight weight) {
        this.weight = weight;
        return this;
    }

    @Schema(required=true, description="")
    public Weight getWeight() {
        return this.weight;
    }

    public void setWeight(Weight weight) {
        this.weight = weight;
    }

    public ShipmentRequestDetails mustArriveByDate(OffsetDateTime mustArriveByDate) {
        this.mustArriveByDate = mustArriveByDate;
        return this;
    }

    @Schema(description="")
    public OffsetDateTime getMustArriveByDate() {
        return this.mustArriveByDate;
    }

    public void setMustArriveByDate(OffsetDateTime mustArriveByDate) {
        this.mustArriveByDate = mustArriveByDate;
    }

    public ShipmentRequestDetails shipDate(OffsetDateTime shipDate) {
        this.shipDate = shipDate;
        return this;
    }

    @Schema(description="")
    public OffsetDateTime getShipDate() {
        return this.shipDate;
    }

    public void setShipDate(OffsetDateTime shipDate) {
        this.shipDate = shipDate;
    }

    public ShipmentRequestDetails shippingServiceOptions(ShippingServiceOptions shippingServiceOptions) {
        this.shippingServiceOptions = shippingServiceOptions;
        return this;
    }

    @Schema(required=true, description="")
    public ShippingServiceOptions getShippingServiceOptions() {
        return this.shippingServiceOptions;
    }

    public void setShippingServiceOptions(ShippingServiceOptions shippingServiceOptions) {
        this.shippingServiceOptions = shippingServiceOptions;
    }

    public ShipmentRequestDetails labelCustomization(LabelCustomization labelCustomization) {
        this.labelCustomization = labelCustomization;
        return this;
    }

    @Schema(description="")
    public LabelCustomization getLabelCustomization() {
        return this.labelCustomization;
    }

    public void setLabelCustomization(LabelCustomization labelCustomization) {
        this.labelCustomization = labelCustomization;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ShipmentRequestDetails shipmentRequestDetails = (ShipmentRequestDetails)o;
        return Objects.equals(this.amazonOrderId, shipmentRequestDetails.amazonOrderId) && Objects.equals(this.sellerOrderId, shipmentRequestDetails.sellerOrderId) && Objects.equals(this.itemList, shipmentRequestDetails.itemList) && Objects.equals(this.shipFromAddress, shipmentRequestDetails.shipFromAddress) && Objects.equals(this.packageDimensions, shipmentRequestDetails.packageDimensions) && Objects.equals(this.weight, shipmentRequestDetails.weight) && Objects.equals(this.mustArriveByDate, shipmentRequestDetails.mustArriveByDate) && Objects.equals(this.shipDate, shipmentRequestDetails.shipDate) && Objects.equals(this.shippingServiceOptions, shipmentRequestDetails.shippingServiceOptions) && Objects.equals(this.labelCustomization, shipmentRequestDetails.labelCustomization);
    }

    public int hashCode() {
        return Objects.hash(this.amazonOrderId, this.sellerOrderId, this.itemList, this.shipFromAddress, this.packageDimensions, this.weight, this.mustArriveByDate, this.shipDate, this.shippingServiceOptions, this.labelCustomization);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ShipmentRequestDetails {\n");
        sb.append("    amazonOrderId: ").append(this.toIndentedString(this.amazonOrderId)).append("\n");
        sb.append("    sellerOrderId: ").append(this.toIndentedString(this.sellerOrderId)).append("\n");
        sb.append("    itemList: ").append(this.toIndentedString(this.itemList)).append("\n");
        sb.append("    shipFromAddress: ").append(this.toIndentedString(this.shipFromAddress)).append("\n");
        sb.append("    packageDimensions: ").append(this.toIndentedString(this.packageDimensions)).append("\n");
        sb.append("    weight: ").append(this.toIndentedString(this.weight)).append("\n");
        sb.append("    mustArriveByDate: ").append(this.toIndentedString(this.mustArriveByDate)).append("\n");
        sb.append("    shipDate: ").append(this.toIndentedString(this.shipDate)).append("\n");
        sb.append("    shippingServiceOptions: ").append(this.toIndentedString(this.shippingServiceOptions)).append("\n");
        sb.append("    labelCustomization: ").append(this.toIndentedString(this.labelCustomization)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

