/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.merchantfulfillment.v0;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import org.threeten.bp.OffsetDateTime;
import software.amazon.spapi.models.merchantfulfillment.v0.Address;
import software.amazon.spapi.models.merchantfulfillment.v0.CurrencyAmount;
import software.amazon.spapi.models.merchantfulfillment.v0.ItemList;
import software.amazon.spapi.models.merchantfulfillment.v0.Label;
import software.amazon.spapi.models.merchantfulfillment.v0.PackageDimensions;
import software.amazon.spapi.models.merchantfulfillment.v0.ShipmentStatus;
import software.amazon.spapi.models.merchantfulfillment.v0.ShippingService;
import software.amazon.spapi.models.merchantfulfillment.v0.Weight;

@Schema(description="The details of a shipment. Includes the shipment status.")
public class Shipment {
    @SerializedName(value="ShipmentId")
    private String shipmentId = null;
    @SerializedName(value="AmazonOrderId")
    private String amazonOrderId = null;
    @SerializedName(value="SellerOrderId")
    private String sellerOrderId = null;
    @SerializedName(value="ItemList")
    private ItemList itemList = null;
    @SerializedName(value="ShipFromAddress")
    private Address shipFromAddress = null;
    @SerializedName(value="ShipToAddress")
    private Address shipToAddress = null;
    @SerializedName(value="PackageDimensions")
    private PackageDimensions packageDimensions = null;
    @SerializedName(value="Weight")
    private Weight weight = null;
    @SerializedName(value="Insurance")
    private CurrencyAmount insurance = null;
    @SerializedName(value="ShippingService")
    private ShippingService shippingService = null;
    @SerializedName(value="Label")
    private Label label = null;
    @SerializedName(value="Status")
    private ShipmentStatus status = null;
    @SerializedName(value="TrackingId")
    private String trackingId = null;
    @SerializedName(value="CreatedDate")
    private OffsetDateTime createdDate = null;
    @SerializedName(value="LastUpdatedDate")
    private OffsetDateTime lastUpdatedDate = null;

    public Shipment shipmentId(String shipmentId) {
        this.shipmentId = shipmentId;
        return this;
    }

    @Schema(required=true, description="")
    public String getShipmentId() {
        return this.shipmentId;
    }

    public void setShipmentId(String shipmentId) {
        this.shipmentId = shipmentId;
    }

    public Shipment amazonOrderId(String amazonOrderId) {
        this.amazonOrderId = amazonOrderId;
        return this;
    }

    @Schema(required=true, description="")
    public String getAmazonOrderId() {
        return this.amazonOrderId;
    }

    public void setAmazonOrderId(String amazonOrderId) {
        this.amazonOrderId = amazonOrderId;
    }

    public Shipment sellerOrderId(String sellerOrderId) {
        this.sellerOrderId = sellerOrderId;
        return this;
    }

    @Schema(description="")
    public String getSellerOrderId() {
        return this.sellerOrderId;
    }

    public void setSellerOrderId(String sellerOrderId) {
        this.sellerOrderId = sellerOrderId;
    }

    public Shipment itemList(ItemList itemList) {
        this.itemList = itemList;
        return this;
    }

    @Schema(required=true, description="")
    public ItemList getItemList() {
        return this.itemList;
    }

    public void setItemList(ItemList itemList) {
        this.itemList = itemList;
    }

    public Shipment shipFromAddress(Address shipFromAddress) {
        this.shipFromAddress = shipFromAddress;
        return this;
    }

    @Schema(required=true, description="")
    public Address getShipFromAddress() {
        return this.shipFromAddress;
    }

    public void setShipFromAddress(Address shipFromAddress) {
        this.shipFromAddress = shipFromAddress;
    }

    public Shipment shipToAddress(Address shipToAddress) {
        this.shipToAddress = shipToAddress;
        return this;
    }

    @Schema(required=true, description="")
    public Address getShipToAddress() {
        return this.shipToAddress;
    }

    public void setShipToAddress(Address shipToAddress) {
        this.shipToAddress = shipToAddress;
    }

    public Shipment packageDimensions(PackageDimensions packageDimensions) {
        this.packageDimensions = packageDimensions;
        return this;
    }

    @Schema(required=true, description="")
    public PackageDimensions getPackageDimensions() {
        return this.packageDimensions;
    }

    public void setPackageDimensions(PackageDimensions packageDimensions) {
        this.packageDimensions = packageDimensions;
    }

    public Shipment weight(Weight weight) {
        this.weight = weight;
        return this;
    }

    @Schema(required=true, description="")
    public Weight getWeight() {
        return this.weight;
    }

    public void setWeight(Weight weight) {
        this.weight = weight;
    }

    public Shipment insurance(CurrencyAmount insurance) {
        this.insurance = insurance;
        return this;
    }

    @Schema(required=true, description="")
    public CurrencyAmount getInsurance() {
        return this.insurance;
    }

    public void setInsurance(CurrencyAmount insurance) {
        this.insurance = insurance;
    }

    public Shipment shippingService(ShippingService shippingService) {
        this.shippingService = shippingService;
        return this;
    }

    @Schema(required=true, description="")
    public ShippingService getShippingService() {
        return this.shippingService;
    }

    public void setShippingService(ShippingService shippingService) {
        this.shippingService = shippingService;
    }

    public Shipment label(Label label) {
        this.label = label;
        return this;
    }

    @Schema(required=true, description="")
    public Label getLabel() {
        return this.label;
    }

    public void setLabel(Label label) {
        this.label = label;
    }

    public Shipment status(ShipmentStatus status) {
        this.status = status;
        return this;
    }

    @Schema(required=true, description="")
    public ShipmentStatus getStatus() {
        return this.status;
    }

    public void setStatus(ShipmentStatus status) {
        this.status = status;
    }

    public Shipment trackingId(String trackingId) {
        this.trackingId = trackingId;
        return this;
    }

    @Schema(description="")
    public String getTrackingId() {
        return this.trackingId;
    }

    public void setTrackingId(String trackingId) {
        this.trackingId = trackingId;
    }

    public Shipment createdDate(OffsetDateTime createdDate) {
        this.createdDate = createdDate;
        return this;
    }

    @Schema(required=true, description="")
    public OffsetDateTime getCreatedDate() {
        return this.createdDate;
    }

    public void setCreatedDate(OffsetDateTime createdDate) {
        this.createdDate = createdDate;
    }

    public Shipment lastUpdatedDate(OffsetDateTime lastUpdatedDate) {
        this.lastUpdatedDate = lastUpdatedDate;
        return this;
    }

    @Schema(description="")
    public OffsetDateTime getLastUpdatedDate() {
        return this.lastUpdatedDate;
    }

    public void setLastUpdatedDate(OffsetDateTime lastUpdatedDate) {
        this.lastUpdatedDate = lastUpdatedDate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Shipment shipment = (Shipment)o;
        return Objects.equals(this.shipmentId, shipment.shipmentId) && Objects.equals(this.amazonOrderId, shipment.amazonOrderId) && Objects.equals(this.sellerOrderId, shipment.sellerOrderId) && Objects.equals(this.itemList, shipment.itemList) && Objects.equals(this.shipFromAddress, shipment.shipFromAddress) && Objects.equals(this.shipToAddress, shipment.shipToAddress) && Objects.equals(this.packageDimensions, shipment.packageDimensions) && Objects.equals(this.weight, shipment.weight) && Objects.equals(this.insurance, shipment.insurance) && Objects.equals(this.shippingService, shipment.shippingService) && Objects.equals(this.label, shipment.label) && Objects.equals((Object)this.status, (Object)shipment.status) && Objects.equals(this.trackingId, shipment.trackingId) && Objects.equals(this.createdDate, shipment.createdDate) && Objects.equals(this.lastUpdatedDate, shipment.lastUpdatedDate);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.shipmentId, this.amazonOrderId, this.sellerOrderId, this.itemList, this.shipFromAddress, this.shipToAddress, this.packageDimensions, this.weight, this.insurance, this.shippingService, this.label, this.status, this.trackingId, this.createdDate, this.lastUpdatedDate});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Shipment {\n");
        sb.append("    shipmentId: ").append(this.toIndentedString(this.shipmentId)).append("\n");
        sb.append("    amazonOrderId: ").append(this.toIndentedString(this.amazonOrderId)).append("\n");
        sb.append("    sellerOrderId: ").append(this.toIndentedString(this.sellerOrderId)).append("\n");
        sb.append("    itemList: ").append(this.toIndentedString(this.itemList)).append("\n");
        sb.append("    shipFromAddress: ").append(this.toIndentedString(this.shipFromAddress)).append("\n");
        sb.append("    shipToAddress: ").append(this.toIndentedString(this.shipToAddress)).append("\n");
        sb.append("    packageDimensions: ").append(this.toIndentedString(this.packageDimensions)).append("\n");
        sb.append("    weight: ").append(this.toIndentedString(this.weight)).append("\n");
        sb.append("    insurance: ").append(this.toIndentedString(this.insurance)).append("\n");
        sb.append("    shippingService: ").append(this.toIndentedString(this.shippingService)).append("\n");
        sb.append("    label: ").append(this.toIndentedString(this.label)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    trackingId: ").append(this.toIndentedString(this.trackingId)).append("\n");
        sb.append("    createdDate: ").append(this.toIndentedString(this.createdDate)).append("\n");
        sb.append("    lastUpdatedDate: ").append(this.toIndentedString(this.lastUpdatedDate)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

