/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.merchantfulfillment.v0;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;

@Schema(description="Information about a rejected shipping service")
public class RejectedShippingService {
    @SerializedName(value="CarrierName")
    private String carrierName = null;
    @SerializedName(value="ShippingServiceName")
    private String shippingServiceName = null;
    @SerializedName(value="ShippingServiceId")
    private String shippingServiceId = null;
    @SerializedName(value="RejectionReasonCode")
    private String rejectionReasonCode = null;
    @SerializedName(value="RejectionReasonMessage")
    private String rejectionReasonMessage = null;

    public RejectedShippingService carrierName(String carrierName) {
        this.carrierName = carrierName;
        return this;
    }

    @Schema(required=true, description="The rejected shipping carrier name. For example, USPS.")
    public String getCarrierName() {
        return this.carrierName;
    }

    public void setCarrierName(String carrierName) {
        this.carrierName = carrierName;
    }

    public RejectedShippingService shippingServiceName(String shippingServiceName) {
        this.shippingServiceName = shippingServiceName;
        return this;
    }

    @Schema(required=true, description="The rejected shipping service localized name. For example, FedEx Standard Overnight.")
    public String getShippingServiceName() {
        return this.shippingServiceName;
    }

    public void setShippingServiceName(String shippingServiceName) {
        this.shippingServiceName = shippingServiceName;
    }

    public RejectedShippingService shippingServiceId(String shippingServiceId) {
        this.shippingServiceId = shippingServiceId;
        return this;
    }

    @Schema(required=true, description="")
    public String getShippingServiceId() {
        return this.shippingServiceId;
    }

    public void setShippingServiceId(String shippingServiceId) {
        this.shippingServiceId = shippingServiceId;
    }

    public RejectedShippingService rejectionReasonCode(String rejectionReasonCode) {
        this.rejectionReasonCode = rejectionReasonCode;
        return this;
    }

    @Schema(required=true, description="A reason code meant to be consumed programatically. For example, `CARRIER_CANNOT_SHIP_TO_POBOX`.")
    public String getRejectionReasonCode() {
        return this.rejectionReasonCode;
    }

    public void setRejectionReasonCode(String rejectionReasonCode) {
        this.rejectionReasonCode = rejectionReasonCode;
    }

    public RejectedShippingService rejectionReasonMessage(String rejectionReasonMessage) {
        this.rejectionReasonMessage = rejectionReasonMessage;
        return this;
    }

    @Schema(description="A localized human readable description of the rejected reason.")
    public String getRejectionReasonMessage() {
        return this.rejectionReasonMessage;
    }

    public void setRejectionReasonMessage(String rejectionReasonMessage) {
        this.rejectionReasonMessage = rejectionReasonMessage;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RejectedShippingService rejectedShippingService = (RejectedShippingService)o;
        return Objects.equals(this.carrierName, rejectedShippingService.carrierName) && Objects.equals(this.shippingServiceName, rejectedShippingService.shippingServiceName) && Objects.equals(this.shippingServiceId, rejectedShippingService.shippingServiceId) && Objects.equals(this.rejectionReasonCode, rejectedShippingService.rejectionReasonCode) && Objects.equals(this.rejectionReasonMessage, rejectedShippingService.rejectionReasonMessage);
    }

    public int hashCode() {
        return Objects.hash(this.carrierName, this.shippingServiceName, this.shippingServiceId, this.rejectionReasonCode, this.rejectionReasonMessage);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class RejectedShippingService {\n");
        sb.append("    carrierName: ").append(this.toIndentedString(this.carrierName)).append("\n");
        sb.append("    shippingServiceName: ").append(this.toIndentedString(this.shippingServiceName)).append("\n");
        sb.append("    shippingServiceId: ").append(this.toIndentedString(this.shippingServiceId)).append("\n");
        sb.append("    rejectionReasonCode: ").append(this.toIndentedString(this.rejectionReasonCode)).append("\n");
        sb.append("    rejectionReasonMessage: ").append(this.toIndentedString(this.rejectionReasonMessage)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

