/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.listings.restrictions.v2021_08_01;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
import java.util.Objects;

@Schema(description="A link to resources related to a listing restriction.")
public class Link {
    @SerializedName(value="resource")
    private String resource = null;
    @SerializedName(value="verb")
    private VerbEnum verb = null;
    @SerializedName(value="title")
    private String title = null;
    @SerializedName(value="type")
    private String type = null;

    public Link resource(String resource) {
        this.resource = resource;
        return this;
    }

    @Schema(required=true, description="The URI of the related resource.")
    public String getResource() {
        return this.resource;
    }

    public void setResource(String resource) {
        this.resource = resource;
    }

    public Link verb(VerbEnum verb) {
        this.verb = verb;
        return this;
    }

    @Schema(required=true, description="The HTTP verb used to interact with the related resource.")
    public VerbEnum getVerb() {
        return this.verb;
    }

    public void setVerb(VerbEnum verb) {
        this.verb = verb;
    }

    public Link title(String title) {
        this.title = title;
        return this;
    }

    @Schema(description="The title of the related resource.")
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public Link type(String type) {
        this.type = type;
        return this;
    }

    @Schema(description="The media type of the related resource.")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Link link = (Link)o;
        return Objects.equals(this.resource, link.resource) && Objects.equals((Object)this.verb, (Object)link.verb) && Objects.equals(this.title, link.title) && Objects.equals(this.type, link.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.resource, this.verb, this.title, this.type});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Link {\n");
        sb.append("    resource: ").append(this.toIndentedString(this.resource)).append("\n");
        sb.append("    verb: ").append(this.toIndentedString((Object)this.verb)).append("\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("    type: ").append(this.toIndentedString(this.type)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum VerbEnum {
        GET("GET");

        private String value;

        private VerbEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static VerbEnum fromValue(String input) {
            for (VerbEnum b : VerbEnum.values()) {
                if (!b.value.equals(input)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<VerbEnum> {
            public void write(JsonWriter jsonWriter, VerbEnum enumeration) throws IOException {
                jsonWriter.value(String.valueOf(enumeration.getValue()));
            }

            public VerbEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return VerbEnum.fromValue(value);
            }
        }
    }
}

