/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.listings.items.v2021_08_01;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import software.amazon.spapi.models.listings.items.v2021_08_01.PatchOperation;

@Schema(description="The request body schema for the `patchListingsItem` operation.")
public class ListingsItemPatchRequest {
    @SerializedName(value="productType")
    private String productType = null;
    @SerializedName(value="patches")
    private List<PatchOperation> patches = new ArrayList<PatchOperation>();

    public ListingsItemPatchRequest productType(String productType) {
        this.productType = productType;
        return this;
    }

    @Schema(required=true, description="The Amazon product type of the listings item.")
    public String getProductType() {
        return this.productType;
    }

    public void setProductType(String productType) {
        this.productType = productType;
    }

    public ListingsItemPatchRequest patches(List<PatchOperation> patches) {
        this.patches = patches;
        return this;
    }

    public ListingsItemPatchRequest addPatchesItem(PatchOperation patchesItem) {
        this.patches.add(patchesItem);
        return this;
    }

    @Schema(required=true, description="One or more JSON Patch operations to perform on the listings item.")
    public List<PatchOperation> getPatches() {
        return this.patches;
    }

    public void setPatches(List<PatchOperation> patches) {
        this.patches = patches;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ListingsItemPatchRequest listingsItemPatchRequest = (ListingsItemPatchRequest)o;
        return Objects.equals(this.productType, listingsItemPatchRequest.productType) && Objects.equals(this.patches, listingsItemPatchRequest.patches);
    }

    public int hashCode() {
        return Objects.hash(this.productType, this.patches);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ListingsItemPatchRequest {\n");
        sb.append("    productType: ").append(this.toIndentedString(this.productType)).append("\n");
        sb.append("    patches: ").append(this.toIndentedString(this.patches)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

