/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.listings.items.v2021_08_01;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.threeten.bp.OffsetDateTime;
import software.amazon.spapi.models.listings.items.v2021_08_01.ItemImage;

@Schema(description="Summary details of a listings item for an Amazon marketplace.")
public class ItemSummaryByMarketplace {
    @SerializedName(value="marketplaceId")
    private String marketplaceId = null;
    @SerializedName(value="asin")
    private String asin = null;
    @SerializedName(value="productType")
    private String productType = null;
    @SerializedName(value="conditionType")
    private ConditionTypeEnum conditionType = null;
    @SerializedName(value="status")
    private List<StatusEnum> status = new ArrayList<StatusEnum>();
    @SerializedName(value="fnSku")
    private String fnSku = null;
    @SerializedName(value="itemName")
    private String itemName = null;
    @SerializedName(value="createdDate")
    private OffsetDateTime createdDate = null;
    @SerializedName(value="lastUpdatedDate")
    private OffsetDateTime lastUpdatedDate = null;
    @SerializedName(value="mainImage")
    private ItemImage mainImage = null;

    public ItemSummaryByMarketplace marketplaceId(String marketplaceId) {
        this.marketplaceId = marketplaceId;
        return this;
    }

    @Schema(required=true, description="A marketplace identifier. Identifies the Amazon marketplace for the listings item.")
    public String getMarketplaceId() {
        return this.marketplaceId;
    }

    public void setMarketplaceId(String marketplaceId) {
        this.marketplaceId = marketplaceId;
    }

    public ItemSummaryByMarketplace asin(String asin) {
        this.asin = asin;
        return this;
    }

    @Schema(description="Amazon Standard Identification Number (ASIN) of the listings item.")
    public String getAsin() {
        return this.asin;
    }

    public void setAsin(String asin) {
        this.asin = asin;
    }

    public ItemSummaryByMarketplace productType(String productType) {
        this.productType = productType;
        return this;
    }

    @Schema(required=true, description="The Amazon product type of the listings item.")
    public String getProductType() {
        return this.productType;
    }

    public void setProductType(String productType) {
        this.productType = productType;
    }

    public ItemSummaryByMarketplace conditionType(ConditionTypeEnum conditionType) {
        this.conditionType = conditionType;
        return this;
    }

    @Schema(description="Identifies the condition of the listings item.")
    public ConditionTypeEnum getConditionType() {
        return this.conditionType;
    }

    public void setConditionType(ConditionTypeEnum conditionType) {
        this.conditionType = conditionType;
    }

    public ItemSummaryByMarketplace status(List<StatusEnum> status) {
        this.status = status;
        return this;
    }

    public ItemSummaryByMarketplace addStatusItem(StatusEnum statusItem) {
        this.status.add(statusItem);
        return this;
    }

    @Schema(required=true, description="Statuses that apply to the listings item.")
    public List<StatusEnum> getStatus() {
        return this.status;
    }

    public void setStatus(List<StatusEnum> status) {
        this.status = status;
    }

    public ItemSummaryByMarketplace fnSku(String fnSku) {
        this.fnSku = fnSku;
        return this;
    }

    @Schema(description="The fulfillment network stock keeping unit is an identifier used by Amazon fulfillment centers to identify each unique item.")
    public String getFnSku() {
        return this.fnSku;
    }

    public void setFnSku(String fnSku) {
        this.fnSku = fnSku;
    }

    public ItemSummaryByMarketplace itemName(String itemName) {
        this.itemName = itemName;
        return this;
    }

    @Schema(description="The name or title associated with an Amazon catalog item.")
    public String getItemName() {
        return this.itemName;
    }

    public void setItemName(String itemName) {
        this.itemName = itemName;
    }

    public ItemSummaryByMarketplace createdDate(OffsetDateTime createdDate) {
        this.createdDate = createdDate;
        return this;
    }

    @Schema(required=true, description="The date the listings item was created in ISO 8601 format.")
    public OffsetDateTime getCreatedDate() {
        return this.createdDate;
    }

    public void setCreatedDate(OffsetDateTime createdDate) {
        this.createdDate = createdDate;
    }

    public ItemSummaryByMarketplace lastUpdatedDate(OffsetDateTime lastUpdatedDate) {
        this.lastUpdatedDate = lastUpdatedDate;
        return this;
    }

    @Schema(required=true, description="The date the listings item was last updated in ISO 8601 format.")
    public OffsetDateTime getLastUpdatedDate() {
        return this.lastUpdatedDate;
    }

    public void setLastUpdatedDate(OffsetDateTime lastUpdatedDate) {
        this.lastUpdatedDate = lastUpdatedDate;
    }

    public ItemSummaryByMarketplace mainImage(ItemImage mainImage) {
        this.mainImage = mainImage;
        return this;
    }

    @Schema(description="")
    public ItemImage getMainImage() {
        return this.mainImage;
    }

    public void setMainImage(ItemImage mainImage) {
        this.mainImage = mainImage;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ItemSummaryByMarketplace itemSummaryByMarketplace = (ItemSummaryByMarketplace)o;
        return Objects.equals(this.marketplaceId, itemSummaryByMarketplace.marketplaceId) && Objects.equals(this.asin, itemSummaryByMarketplace.asin) && Objects.equals(this.productType, itemSummaryByMarketplace.productType) && Objects.equals((Object)this.conditionType, (Object)itemSummaryByMarketplace.conditionType) && Objects.equals(this.status, itemSummaryByMarketplace.status) && Objects.equals(this.fnSku, itemSummaryByMarketplace.fnSku) && Objects.equals(this.itemName, itemSummaryByMarketplace.itemName) && Objects.equals(this.createdDate, itemSummaryByMarketplace.createdDate) && Objects.equals(this.lastUpdatedDate, itemSummaryByMarketplace.lastUpdatedDate) && Objects.equals(this.mainImage, itemSummaryByMarketplace.mainImage);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.marketplaceId, this.asin, this.productType, this.conditionType, this.status, this.fnSku, this.itemName, this.createdDate, this.lastUpdatedDate, this.mainImage});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ItemSummaryByMarketplace {\n");
        sb.append("    marketplaceId: ").append(this.toIndentedString(this.marketplaceId)).append("\n");
        sb.append("    asin: ").append(this.toIndentedString(this.asin)).append("\n");
        sb.append("    productType: ").append(this.toIndentedString(this.productType)).append("\n");
        sb.append("    conditionType: ").append(this.toIndentedString((Object)this.conditionType)).append("\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("    fnSku: ").append(this.toIndentedString(this.fnSku)).append("\n");
        sb.append("    itemName: ").append(this.toIndentedString(this.itemName)).append("\n");
        sb.append("    createdDate: ").append(this.toIndentedString(this.createdDate)).append("\n");
        sb.append("    lastUpdatedDate: ").append(this.toIndentedString(this.lastUpdatedDate)).append("\n");
        sb.append("    mainImage: ").append(this.toIndentedString(this.mainImage)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum StatusEnum {
        BUYABLE("BUYABLE"),
        DISCOVERABLE("DISCOVERABLE");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static StatusEnum fromValue(String input) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!b.value.equals(input)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<StatusEnum> {
            public void write(JsonWriter jsonWriter, StatusEnum enumeration) throws IOException {
                jsonWriter.value(String.valueOf(enumeration.getValue()));
            }

            public StatusEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return StatusEnum.fromValue(value);
            }
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum ConditionTypeEnum {
        NEW_NEW("new_new"),
        NEW_OPEN_BOX("new_open_box"),
        NEW_OEM("new_oem"),
        REFURBISHED_REFURBISHED("refurbished_refurbished"),
        USED_LIKE_NEW("used_like_new"),
        USED_VERY_GOOD("used_very_good"),
        USED_GOOD("used_good"),
        USED_ACCEPTABLE("used_acceptable"),
        COLLECTIBLE_LIKE_NEW("collectible_like_new"),
        COLLECTIBLE_VERY_GOOD("collectible_very_good"),
        COLLECTIBLE_GOOD("collectible_good"),
        COLLECTIBLE_ACCEPTABLE("collectible_acceptable"),
        CLUB_CLUB("club_club");

        private String value;

        private ConditionTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static ConditionTypeEnum fromValue(String input) {
            for (ConditionTypeEnum b : ConditionTypeEnum.values()) {
                if (!b.value.equals(input)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<ConditionTypeEnum> {
            public void write(JsonWriter jsonWriter, ConditionTypeEnum enumeration) throws IOException {
                jsonWriter.value(String.valueOf(enumeration.getValue()));
            }

            public ConditionTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return ConditionTypeEnum.fromValue(value);
            }
        }
    }
}

