/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.listings.items.v2021_08_01;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import software.amazon.spapi.models.listings.items.v2021_08_01.ItemRelationship;

@Schema(description="Relationship details for the listing item in the specified marketplace.")
public class ItemRelationshipsByMarketplace {
    @SerializedName(value="marketplaceId")
    private String marketplaceId = null;
    @SerializedName(value="relationships")
    private List<ItemRelationship> relationships = new ArrayList<ItemRelationship>();

    public ItemRelationshipsByMarketplace marketplaceId(String marketplaceId) {
        this.marketplaceId = marketplaceId;
        return this;
    }

    @Schema(required=true, description="Amazon marketplace identifier.")
    public String getMarketplaceId() {
        return this.marketplaceId;
    }

    public void setMarketplaceId(String marketplaceId) {
        this.marketplaceId = marketplaceId;
    }

    public ItemRelationshipsByMarketplace relationships(List<ItemRelationship> relationships) {
        this.relationships = relationships;
        return this;
    }

    public ItemRelationshipsByMarketplace addRelationshipsItem(ItemRelationship relationshipsItem) {
        this.relationships.add(relationshipsItem);
        return this;
    }

    @Schema(required=true, description="Relationships for the listing item.")
    public List<ItemRelationship> getRelationships() {
        return this.relationships;
    }

    public void setRelationships(List<ItemRelationship> relationships) {
        this.relationships = relationships;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ItemRelationshipsByMarketplace itemRelationshipsByMarketplace = (ItemRelationshipsByMarketplace)o;
        return Objects.equals(this.marketplaceId, itemRelationshipsByMarketplace.marketplaceId) && Objects.equals(this.relationships, itemRelationshipsByMarketplace.relationships);
    }

    public int hashCode() {
        return Objects.hash(this.marketplaceId, this.relationships);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ItemRelationshipsByMarketplace {\n");
        sb.append("    marketplaceId: ").append(this.toIndentedString(this.marketplaceId)).append("\n");
        sb.append("    relationships: ").append(this.toIndentedString(this.relationships)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

