/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.listings.items.v2021_08_01;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
import java.util.Objects;
import software.amazon.spapi.models.listings.items.v2021_08_01.Audience;
import software.amazon.spapi.models.listings.items.v2021_08_01.Money;
import software.amazon.spapi.models.listings.items.v2021_08_01.Points;

@Schema(description="Offer details of a listings item for an Amazon marketplace.")
public class ItemOfferByMarketplace {
    @SerializedName(value="marketplaceId")
    private String marketplaceId = null;
    @SerializedName(value="offerType")
    private OfferTypeEnum offerType = null;
    @SerializedName(value="price")
    private Money price = null;
    @SerializedName(value="points")
    private Points points = null;
    @SerializedName(value="audience")
    private Audience audience = null;

    public ItemOfferByMarketplace marketplaceId(String marketplaceId) {
        this.marketplaceId = marketplaceId;
        return this;
    }

    @Schema(required=true, description="The Amazon marketplace identifier.")
    public String getMarketplaceId() {
        return this.marketplaceId;
    }

    public void setMarketplaceId(String marketplaceId) {
        this.marketplaceId = marketplaceId;
    }

    public ItemOfferByMarketplace offerType(OfferTypeEnum offerType) {
        this.offerType = offerType;
        return this;
    }

    @Schema(required=true, description="Type of offer for the listings item.")
    public OfferTypeEnum getOfferType() {
        return this.offerType;
    }

    public void setOfferType(OfferTypeEnum offerType) {
        this.offerType = offerType;
    }

    public ItemOfferByMarketplace price(Money price) {
        this.price = price;
        return this;
    }

    @Schema(required=true, description="")
    public Money getPrice() {
        return this.price;
    }

    public void setPrice(Money price) {
        this.price = price;
    }

    public ItemOfferByMarketplace points(Points points) {
        this.points = points;
        return this;
    }

    @Schema(description="")
    public Points getPoints() {
        return this.points;
    }

    public void setPoints(Points points) {
        this.points = points;
    }

    public ItemOfferByMarketplace audience(Audience audience) {
        this.audience = audience;
        return this;
    }

    @Schema(description="")
    public Audience getAudience() {
        return this.audience;
    }

    public void setAudience(Audience audience) {
        this.audience = audience;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ItemOfferByMarketplace itemOfferByMarketplace = (ItemOfferByMarketplace)o;
        return Objects.equals(this.marketplaceId, itemOfferByMarketplace.marketplaceId) && Objects.equals((Object)this.offerType, (Object)itemOfferByMarketplace.offerType) && Objects.equals(this.price, itemOfferByMarketplace.price) && Objects.equals(this.points, itemOfferByMarketplace.points) && Objects.equals(this.audience, itemOfferByMarketplace.audience);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.marketplaceId, this.offerType, this.price, this.points, this.audience});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ItemOfferByMarketplace {\n");
        sb.append("    marketplaceId: ").append(this.toIndentedString(this.marketplaceId)).append("\n");
        sb.append("    offerType: ").append(this.toIndentedString((Object)this.offerType)).append("\n");
        sb.append("    price: ").append(this.toIndentedString(this.price)).append("\n");
        sb.append("    points: ").append(this.toIndentedString(this.points)).append("\n");
        sb.append("    audience: ").append(this.toIndentedString(this.audience)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum OfferTypeEnum {
        B2C("B2C"),
        B2B("B2B");

        private String value;

        private OfferTypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static OfferTypeEnum fromValue(String input) {
            for (OfferTypeEnum b : OfferTypeEnum.values()) {
                if (!b.value.equals(input)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<OfferTypeEnum> {
            public void write(JsonWriter jsonWriter, OfferTypeEnum enumeration) throws IOException {
                jsonWriter.value(String.valueOf(enumeration.getValue()));
            }

            public OfferTypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return OfferTypeEnum.fromValue(value);
            }
        }
    }
}

