/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.listings.items.v2021_08_01;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;

@Schema(description="The image for the listings item.")
public class ItemImage {
    @SerializedName(value="link")
    private String link = null;
    @SerializedName(value="height")
    private Integer height = null;
    @SerializedName(value="width")
    private Integer width = null;

    public ItemImage link(String link) {
        this.link = link;
        return this;
    }

    @Schema(required=true, description="The link, or URL, to the image.")
    public String getLink() {
        return this.link;
    }

    public void setLink(String link) {
        this.link = link;
    }

    public ItemImage height(Integer height) {
        this.height = height;
        return this;
    }

    @Schema(required=true, description="The height of the image in pixels.")
    public Integer getHeight() {
        return this.height;
    }

    public void setHeight(Integer height) {
        this.height = height;
    }

    public ItemImage width(Integer width) {
        this.width = width;
        return this;
    }

    @Schema(required=true, description="The width of the image in pixels.")
    public Integer getWidth() {
        return this.width;
    }

    public void setWidth(Integer width) {
        this.width = width;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ItemImage itemImage = (ItemImage)o;
        return Objects.equals(this.link, itemImage.link) && Objects.equals(this.height, itemImage.height) && Objects.equals(this.width, itemImage.width);
    }

    public int hashCode() {
        return Objects.hash(this.link, this.height, this.width);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ItemImage {\n");
        sb.append("    link: ").append(this.toIndentedString(this.link)).append("\n");
        sb.append("    height: ").append(this.toIndentedString(this.height)).append("\n");
        sb.append("    width: ").append(this.toIndentedString(this.width)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

