/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.listings.items.v2021_08_01;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;

@Schema(description="Identity attributes associated with the item in the Amazon catalog for the indicated Amazon marketplace.")
public class ItemIdentifiersByMarketplace {
    @SerializedName(value="marketplaceId")
    private String marketplaceId = null;
    @SerializedName(value="asin")
    private String asin = null;

    public ItemIdentifiersByMarketplace marketplaceId(String marketplaceId) {
        this.marketplaceId = marketplaceId;
        return this;
    }

    @Schema(description="A marketplace identifier. Identifies the Amazon marketplace for the listings item.")
    public String getMarketplaceId() {
        return this.marketplaceId;
    }

    public void setMarketplaceId(String marketplaceId) {
        this.marketplaceId = marketplaceId;
    }

    public ItemIdentifiersByMarketplace asin(String asin) {
        this.asin = asin;
        return this;
    }

    @Schema(description="Amazon Standard Identification Number (ASIN) of the listings item.")
    public String getAsin() {
        return this.asin;
    }

    public void setAsin(String asin) {
        this.asin = asin;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ItemIdentifiersByMarketplace itemIdentifiersByMarketplace = (ItemIdentifiersByMarketplace)o;
        return Objects.equals(this.marketplaceId, itemIdentifiersByMarketplace.marketplaceId) && Objects.equals(this.asin, itemIdentifiersByMarketplace.asin);
    }

    public int hashCode() {
        return Objects.hash(this.marketplaceId, this.asin);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ItemIdentifiersByMarketplace {\n");
        sb.append("    marketplaceId: ").append(this.toIndentedString(this.marketplaceId)).append("\n");
        sb.append("    asin: ").append(this.toIndentedString(this.asin)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

