/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.listings.items.v2021_08_01;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import software.amazon.spapi.models.listings.items.v2021_08_01.FulfillmentAvailability;
import software.amazon.spapi.models.listings.items.v2021_08_01.ItemAttributes;
import software.amazon.spapi.models.listings.items.v2021_08_01.ItemIssues;
import software.amazon.spapi.models.listings.items.v2021_08_01.ItemOffers;
import software.amazon.spapi.models.listings.items.v2021_08_01.ItemProcurement;
import software.amazon.spapi.models.listings.items.v2021_08_01.ItemProductTypes;
import software.amazon.spapi.models.listings.items.v2021_08_01.ItemRelationships;
import software.amazon.spapi.models.listings.items.v2021_08_01.ItemSummaries;

@Schema(description="A listings item.")
public class Item {
    @SerializedName(value="sku")
    private String sku = null;
    @SerializedName(value="summaries")
    private ItemSummaries summaries = null;
    @SerializedName(value="attributes")
    private ItemAttributes attributes = null;
    @SerializedName(value="issues")
    private ItemIssues issues = null;
    @SerializedName(value="offers")
    private ItemOffers offers = null;
    @SerializedName(value="fulfillmentAvailability")
    private List<FulfillmentAvailability> fulfillmentAvailability = null;
    @SerializedName(value="procurement")
    private List<ItemProcurement> procurement = null;
    @SerializedName(value="relationships")
    private ItemRelationships relationships = null;
    @SerializedName(value="productTypes")
    private ItemProductTypes productTypes = null;

    public Item sku(String sku) {
        this.sku = sku;
        return this;
    }

    @Schema(required=true, description="A selling partner provided identifier for an Amazon listing.")
    public String getSku() {
        return this.sku;
    }

    public void setSku(String sku) {
        this.sku = sku;
    }

    public Item summaries(ItemSummaries summaries) {
        this.summaries = summaries;
        return this;
    }

    @Schema(description="")
    public ItemSummaries getSummaries() {
        return this.summaries;
    }

    public void setSummaries(ItemSummaries summaries) {
        this.summaries = summaries;
    }

    public Item attributes(ItemAttributes attributes) {
        this.attributes = attributes;
        return this;
    }

    @Schema(description="")
    public ItemAttributes getAttributes() {
        return this.attributes;
    }

    public void setAttributes(ItemAttributes attributes) {
        this.attributes = attributes;
    }

    public Item issues(ItemIssues issues) {
        this.issues = issues;
        return this;
    }

    @Schema(description="")
    public ItemIssues getIssues() {
        return this.issues;
    }

    public void setIssues(ItemIssues issues) {
        this.issues = issues;
    }

    public Item offers(ItemOffers offers) {
        this.offers = offers;
        return this;
    }

    @Schema(description="")
    public ItemOffers getOffers() {
        return this.offers;
    }

    public void setOffers(ItemOffers offers) {
        this.offers = offers;
    }

    public Item fulfillmentAvailability(List<FulfillmentAvailability> fulfillmentAvailability) {
        this.fulfillmentAvailability = fulfillmentAvailability;
        return this;
    }

    public Item addFulfillmentAvailabilityItem(FulfillmentAvailability fulfillmentAvailabilityItem) {
        if (this.fulfillmentAvailability == null) {
            this.fulfillmentAvailability = new ArrayList<FulfillmentAvailability>();
        }
        this.fulfillmentAvailability.add(fulfillmentAvailabilityItem);
        return this;
    }

    @Schema(description="The fulfillment availability for the listings item.")
    public List<FulfillmentAvailability> getFulfillmentAvailability() {
        return this.fulfillmentAvailability;
    }

    public void setFulfillmentAvailability(List<FulfillmentAvailability> fulfillmentAvailability) {
        this.fulfillmentAvailability = fulfillmentAvailability;
    }

    public Item procurement(List<ItemProcurement> procurement) {
        this.procurement = procurement;
        return this;
    }

    public Item addProcurementItem(ItemProcurement procurementItem) {
        if (this.procurement == null) {
            this.procurement = new ArrayList<ItemProcurement>();
        }
        this.procurement.add(procurementItem);
        return this;
    }

    @Schema(description="The vendor procurement information for the listings item.")
    public List<ItemProcurement> getProcurement() {
        return this.procurement;
    }

    public void setProcurement(List<ItemProcurement> procurement) {
        this.procurement = procurement;
    }

    public Item relationships(ItemRelationships relationships) {
        this.relationships = relationships;
        return this;
    }

    @Schema(description="")
    public ItemRelationships getRelationships() {
        return this.relationships;
    }

    public void setRelationships(ItemRelationships relationships) {
        this.relationships = relationships;
    }

    public Item productTypes(ItemProductTypes productTypes) {
        this.productTypes = productTypes;
        return this;
    }

    @Schema(description="")
    public ItemProductTypes getProductTypes() {
        return this.productTypes;
    }

    public void setProductTypes(ItemProductTypes productTypes) {
        this.productTypes = productTypes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Item item = (Item)o;
        return Objects.equals(this.sku, item.sku) && Objects.equals(this.summaries, item.summaries) && Objects.equals(this.attributes, item.attributes) && Objects.equals(this.issues, item.issues) && Objects.equals(this.offers, item.offers) && Objects.equals(this.fulfillmentAvailability, item.fulfillmentAvailability) && Objects.equals(this.procurement, item.procurement) && Objects.equals(this.relationships, item.relationships) && Objects.equals(this.productTypes, item.productTypes);
    }

    public int hashCode() {
        return Objects.hash(this.sku, this.summaries, this.attributes, this.issues, this.offers, this.fulfillmentAvailability, this.procurement, this.relationships, this.productTypes);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Item {\n");
        sb.append("    sku: ").append(this.toIndentedString(this.sku)).append("\n");
        sb.append("    summaries: ").append(this.toIndentedString(this.summaries)).append("\n");
        sb.append("    attributes: ").append(this.toIndentedString(this.attributes)).append("\n");
        sb.append("    issues: ").append(this.toIndentedString(this.issues)).append("\n");
        sb.append("    offers: ").append(this.toIndentedString(this.offers)).append("\n");
        sb.append("    fulfillmentAvailability: ").append(this.toIndentedString(this.fulfillmentAvailability)).append("\n");
        sb.append("    procurement: ").append(this.toIndentedString(this.procurement)).append("\n");
        sb.append("    relationships: ").append(this.toIndentedString(this.relationships)).append("\n");
        sb.append("    productTypes: ").append(this.toIndentedString(this.productTypes)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

