/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.listings.items.v2021_08_01;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
import java.util.Objects;
import org.threeten.bp.OffsetDateTime;

@Schema(description="Conveying the status of the listed enforcement actions and, if applicable, provides information about the exemption's expiry date.")
public class IssueExemption {
    @SerializedName(value="status")
    private StatusEnum status = null;
    @SerializedName(value="expiryDate")
    private OffsetDateTime expiryDate = null;

    public IssueExemption status(StatusEnum status) {
        this.status = status;
        return this;
    }

    @Schema(required=true, description="This field indicates the current exemption status for the listed enforcement actions. It can take values such as `EXEMPT`, signifying permanent exemption, `EXEMPT_UNTIL_EXPIRY_DATE` indicating temporary exemption until a specified date, or `NOT_EXEMPT` signifying no exemptions, and enforcement actions were already applied.")
    public StatusEnum getStatus() {
        return this.status;
    }

    public void setStatus(StatusEnum status) {
        this.status = status;
    }

    public IssueExemption expiryDate(OffsetDateTime expiryDate) {
        this.expiryDate = expiryDate;
        return this;
    }

    @Schema(example="2023-10-28T00:36:48.914Z", description="Represents the timestamp, in ISO 8601 format, that specifies the date when the temporary exemptions expires, and Amazon begins enforcing the listed actions.")
    public OffsetDateTime getExpiryDate() {
        return this.expiryDate;
    }

    public void setExpiryDate(OffsetDateTime expiryDate) {
        this.expiryDate = expiryDate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IssueExemption issueExemption = (IssueExemption)o;
        return Objects.equals((Object)this.status, (Object)issueExemption.status) && Objects.equals(this.expiryDate, issueExemption.expiryDate);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.status, this.expiryDate});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IssueExemption {\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("    expiryDate: ").append(this.toIndentedString(this.expiryDate)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum StatusEnum {
        EXEMPT("EXEMPT"),
        EXEMPT_UNTIL_EXPIRY_DATE("EXEMPT_UNTIL_EXPIRY_DATE"),
        NOT_EXEMPT("NOT_EXEMPT");

        private String value;

        private StatusEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static StatusEnum fromValue(String input) {
            for (StatusEnum b : StatusEnum.values()) {
                if (!b.value.equals(input)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<StatusEnum> {
            public void write(JsonWriter jsonWriter, StatusEnum enumeration) throws IOException {
                jsonWriter.value(String.valueOf(enumeration.getValue()));
            }

            public StatusEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return StatusEnum.fromValue(value);
            }
        }
    }
}

