/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.listings.items.v2021_08_01;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import software.amazon.spapi.models.listings.items.v2021_08_01.IssueEnforcementAction;
import software.amazon.spapi.models.listings.items.v2021_08_01.IssueExemption;

@Schema(description="This field provides information about the enforcement actions taken by Amazon that affect the publishing or status of a listing. It also includes details about any associated exemptions.")
public class IssueEnforcements {
    @SerializedName(value="actions")
    private List<IssueEnforcementAction> actions = new ArrayList<IssueEnforcementAction>();
    @SerializedName(value="exemption")
    private IssueExemption exemption = null;

    public IssueEnforcements actions(List<IssueEnforcementAction> actions) {
        this.actions = actions;
        return this;
    }

    public IssueEnforcements addActionsItem(IssueEnforcementAction actionsItem) {
        this.actions.add(actionsItem);
        return this;
    }

    @Schema(required=true, description="List of enforcement actions taken by Amazon that affect the publishing or status of a listing.")
    public List<IssueEnforcementAction> getActions() {
        return this.actions;
    }

    public void setActions(List<IssueEnforcementAction> actions) {
        this.actions = actions;
    }

    public IssueEnforcements exemption(IssueExemption exemption) {
        this.exemption = exemption;
        return this;
    }

    @Schema(required=true, description="")
    public IssueExemption getExemption() {
        return this.exemption;
    }

    public void setExemption(IssueExemption exemption) {
        this.exemption = exemption;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IssueEnforcements issueEnforcements = (IssueEnforcements)o;
        return Objects.equals(this.actions, issueEnforcements.actions) && Objects.equals(this.exemption, issueEnforcements.exemption);
    }

    public int hashCode() {
        return Objects.hash(this.actions, this.exemption);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IssueEnforcements {\n");
        sb.append("    actions: ").append(this.toIndentedString(this.actions)).append("\n");
        sb.append("    exemption: ").append(this.toIndentedString(this.exemption)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

