/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.listings.items.v2021_08_01;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;

@Schema(description="Buyer segment or program this offer is applicable to.")
public class Audience {
    @SerializedName(value="value")
    private String value = null;
    @SerializedName(value="displayName")
    private String displayName = null;

    public Audience value(String value) {
        this.value = value;
        return this;
    }

    @Schema(example="ALL", description="Name of the audience an offer is applicable to.   Common values:   * 'ALL' - Standard offer audience for buyers on Amazon retail websites.   * 'B2B' - Offer audience for Amazon Business website buyers.")
    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public Audience displayName(String displayName) {
        this.displayName = displayName;
        return this;
    }

    @Schema(description="Localized display name for the audience.")
    public String getDisplayName() {
        return this.displayName;
    }

    public void setDisplayName(String displayName) {
        this.displayName = displayName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Audience audience = (Audience)o;
        return Objects.equals(this.value, audience.value) && Objects.equals(this.displayName, audience.displayName);
    }

    public int hashCode() {
        return Objects.hash(this.value, this.displayName);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Audience {\n");
        sb.append("    value: ").append(this.toIndentedString(this.value)).append("\n");
        sb.append("    displayName: ").append(this.toIndentedString(this.displayName)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

