/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.invoicing.v0;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;

@JsonAdapter(value=Adapter.class)
public enum PaymentMethodEnum {
    CREDITCARD("CreditCard"),
    DEBITCARD("DebitCard"),
    PIX("Pix"),
    BANKSLIP("BankSlip"),
    GIFTCARD("GiftCard"),
    OTHER("Other");

    private String value;

    private PaymentMethodEnum(String value) {
        this.value = value;
    }

    public String getValue() {
        return this.value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static PaymentMethodEnum fromValue(String input) {
        for (PaymentMethodEnum b : PaymentMethodEnum.values()) {
            if (!b.value.equals(input)) continue;
            return b;
        }
        return null;
    }

    public static class Adapter
    extends TypeAdapter<PaymentMethodEnum> {
        public void write(JsonWriter jsonWriter, PaymentMethodEnum enumeration) throws IOException {
            jsonWriter.value(String.valueOf(enumeration.getValue()));
        }

        public PaymentMethodEnum read(JsonReader jsonReader) throws IOException {
            String value = jsonReader.nextString();
            return PaymentMethodEnum.fromValue(value);
        }
    }
}

