/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.invoicing.v0;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import software.amazon.spapi.models.invoicing.v0.Money;
import software.amazon.spapi.models.invoicing.v0.PaymentMethodEnum;

@Schema(description="Payment transaction information")
public class PaymentInformation {
    @SerializedName(value="PaymentMethod")
    private PaymentMethodEnum paymentMethod = null;
    @SerializedName(value="AcquirerId")
    private String acquirerId = null;
    @SerializedName(value="CardBrand")
    private String cardBrand = null;
    @SerializedName(value="PaymentValue")
    private Money paymentValue = null;
    @SerializedName(value="AuthorizationCode")
    private String authorizationCode = null;

    public PaymentInformation paymentMethod(PaymentMethodEnum paymentMethod) {
        this.paymentMethod = paymentMethod;
        return this;
    }

    @Schema(description="")
    public PaymentMethodEnum getPaymentMethod() {
        return this.paymentMethod;
    }

    public void setPaymentMethod(PaymentMethodEnum paymentMethod) {
        this.paymentMethod = paymentMethod;
    }

    public PaymentInformation acquirerId(String acquirerId) {
        this.acquirerId = acquirerId;
        return this;
    }

    @Schema(description="Government ID of acquirer")
    public String getAcquirerId() {
        return this.acquirerId;
    }

    public void setAcquirerId(String acquirerId) {
        this.acquirerId = acquirerId;
    }

    public PaymentInformation cardBrand(String cardBrand) {
        this.cardBrand = cardBrand;
        return this;
    }

    @Schema(description="Credit card brand (if payment method is CreditCard)")
    public String getCardBrand() {
        return this.cardBrand;
    }

    public void setCardBrand(String cardBrand) {
        this.cardBrand = cardBrand;
    }

    public PaymentInformation paymentValue(Money paymentValue) {
        this.paymentValue = paymentValue;
        return this;
    }

    @Schema(description="")
    public Money getPaymentValue() {
        return this.paymentValue;
    }

    public void setPaymentValue(Money paymentValue) {
        this.paymentValue = paymentValue;
    }

    public PaymentInformation authorizationCode(String authorizationCode) {
        this.authorizationCode = authorizationCode;
        return this;
    }

    @Schema(description="Authorization code for this payment")
    public String getAuthorizationCode() {
        return this.authorizationCode;
    }

    public void setAuthorizationCode(String authorizationCode) {
        this.authorizationCode = authorizationCode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PaymentInformation paymentInformation = (PaymentInformation)o;
        return Objects.equals((Object)this.paymentMethod, (Object)paymentInformation.paymentMethod) && Objects.equals(this.acquirerId, paymentInformation.acquirerId) && Objects.equals(this.cardBrand, paymentInformation.cardBrand) && Objects.equals(this.paymentValue, paymentInformation.paymentValue) && Objects.equals(this.authorizationCode, paymentInformation.authorizationCode);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.paymentMethod, this.acquirerId, this.cardBrand, this.paymentValue, this.authorizationCode});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PaymentInformation {\n");
        sb.append("    paymentMethod: ").append(this.toIndentedString((Object)this.paymentMethod)).append("\n");
        sb.append("    acquirerId: ").append(this.toIndentedString(this.acquirerId)).append("\n");
        sb.append("    cardBrand: ").append(this.toIndentedString(this.cardBrand)).append("\n");
        sb.append("    paymentValue: ").append(this.toIndentedString(this.paymentValue)).append("\n");
        sb.append("    authorizationCode: ").append(this.toIndentedString(this.authorizationCode)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

