/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.invoices.v2024_06_19;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.threeten.bp.OffsetDateTime;
import software.amazon.spapi.models.invoices.v2024_06_19.TransactionIdentifier;

@Schema(description="Provides detailed information about an invoice.")
public class Invoice {
    @SerializedName(value="date")
    private OffsetDateTime date = null;
    @SerializedName(value="errorCode")
    private String errorCode = null;
    @SerializedName(value="externalInvoiceId")
    private String externalInvoiceId = null;
    @SerializedName(value="govResponse")
    private String govResponse = null;
    @SerializedName(value="id")
    private String id = null;
    @SerializedName(value="invoiceType")
    private String invoiceType = null;
    @SerializedName(value="series")
    private String series = null;
    @SerializedName(value="status")
    private String status = null;
    @SerializedName(value="transactionIds")
    private List<TransactionIdentifier> transactionIds = null;
    @SerializedName(value="transactionType")
    private String transactionType = null;

    public Invoice date(OffsetDateTime date) {
        this.date = date;
        return this;
    }

    @Schema(description="The date and time the invoice is issued. Values are in [ISO 8601](https://developer-docs.amazon.com/sp-api/docs/iso-8601) date-time format.")
    public OffsetDateTime getDate() {
        return this.date;
    }

    public void setDate(OffsetDateTime date) {
        this.date = date;
    }

    public Invoice errorCode(String errorCode) {
        this.errorCode = errorCode;
        return this;
    }

    @Schema(description="If the invoice is in an error state, this attribute displays the error code.")
    public String getErrorCode() {
        return this.errorCode;
    }

    public void setErrorCode(String errorCode) {
        this.errorCode = errorCode;
    }

    public Invoice externalInvoiceId(String externalInvoiceId) {
        this.externalInvoiceId = externalInvoiceId;
        return this;
    }

    @Schema(description="The invoice identifier that is used by an external party. This is typically the government agency that authorized the invoice.")
    public String getExternalInvoiceId() {
        return this.externalInvoiceId;
    }

    public void setExternalInvoiceId(String externalInvoiceId) {
        this.externalInvoiceId = externalInvoiceId;
    }

    public Invoice govResponse(String govResponse) {
        this.govResponse = govResponse;
        return this;
    }

    @Schema(description="The response message from the government authority when there is an error during invoice issuance.")
    public String getGovResponse() {
        return this.govResponse;
    }

    public void setGovResponse(String govResponse) {
        this.govResponse = govResponse;
    }

    public Invoice id(String id) {
        this.id = id;
        return this;
    }

    @Schema(description="The invoice identifier.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Invoice invoiceType(String invoiceType) {
        this.invoiceType = invoiceType;
        return this;
    }

    @Schema(description="The classification of the invoice type. This varies across marketplaces. Use the `getInvoicesAttributes` operation to check `invoiceType` options.")
    public String getInvoiceType() {
        return this.invoiceType;
    }

    public void setInvoiceType(String invoiceType) {
        this.invoiceType = invoiceType;
    }

    public Invoice series(String series) {
        this.series = series;
        return this;
    }

    @Schema(description="Use this identifier in conjunction with `externalInvoiceId` to identify invoices from the same seller.")
    public String getSeries() {
        return this.series;
    }

    public void setSeries(String series) {
        this.series = series;
    }

    public Invoice status(String status) {
        this.status = status;
        return this;
    }

    @Schema(description="The invoice status classification. Use the `getInvoicesAttributes` operation to check invoice status options.")
    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public Invoice transactionIds(List<TransactionIdentifier> transactionIds) {
        this.transactionIds = transactionIds;
        return this;
    }

    public Invoice addTransactionIdsItem(TransactionIdentifier transactionIdsItem) {
        if (this.transactionIds == null) {
            this.transactionIds = new ArrayList<TransactionIdentifier>();
        }
        this.transactionIds.add(transactionIdsItem);
        return this;
    }

    @Schema(description="List with identifiers for the transactions associated to the invoice.")
    public List<TransactionIdentifier> getTransactionIds() {
        return this.transactionIds;
    }

    public void setTransactionIds(List<TransactionIdentifier> transactionIds) {
        this.transactionIds = transactionIds;
    }

    public Invoice transactionType(String transactionType) {
        this.transactionType = transactionType;
        return this;
    }

    @Schema(description="Classification of the transaction that originated this invoice. Use the `getInvoicesAttributes` operation to check `transactionType` options.")
    public String getTransactionType() {
        return this.transactionType;
    }

    public void setTransactionType(String transactionType) {
        this.transactionType = transactionType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Invoice invoice = (Invoice)o;
        return Objects.equals(this.date, invoice.date) && Objects.equals(this.errorCode, invoice.errorCode) && Objects.equals(this.externalInvoiceId, invoice.externalInvoiceId) && Objects.equals(this.govResponse, invoice.govResponse) && Objects.equals(this.id, invoice.id) && Objects.equals(this.invoiceType, invoice.invoiceType) && Objects.equals(this.series, invoice.series) && Objects.equals(this.status, invoice.status) && Objects.equals(this.transactionIds, invoice.transactionIds) && Objects.equals(this.transactionType, invoice.transactionType);
    }

    public int hashCode() {
        return Objects.hash(this.date, this.errorCode, this.externalInvoiceId, this.govResponse, this.id, this.invoiceType, this.series, this.status, this.transactionIds, this.transactionType);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Invoice {\n");
        sb.append("    date: ").append(this.toIndentedString(this.date)).append("\n");
        sb.append("    errorCode: ").append(this.toIndentedString(this.errorCode)).append("\n");
        sb.append("    externalInvoiceId: ").append(this.toIndentedString(this.externalInvoiceId)).append("\n");
        sb.append("    govResponse: ").append(this.toIndentedString(this.govResponse)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    invoiceType: ").append(this.toIndentedString(this.invoiceType)).append("\n");
        sb.append("    series: ").append(this.toIndentedString(this.series)).append("\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("    transactionIds: ").append(this.toIndentedString(this.transactionIds)).append("\n");
        sb.append("    transactionType: ").append(this.toIndentedString(this.transactionType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

