/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.invoices.v2024_06_19;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.threeten.bp.OffsetDateTime;
import software.amazon.spapi.models.invoices.v2024_06_19.ExportStatus;

@Schema(description="Detailed information about the export.")
public class Export {
    @SerializedName(value="errorMessage")
    private String errorMessage = null;
    @SerializedName(value="exportId")
    private String exportId = null;
    @SerializedName(value="generateExportFinishedAt")
    private OffsetDateTime generateExportFinishedAt = null;
    @SerializedName(value="generateExportStartedAt")
    private OffsetDateTime generateExportStartedAt = null;
    @SerializedName(value="invoicesDocumentIds")
    private List<String> invoicesDocumentIds = null;
    @SerializedName(value="status")
    private ExportStatus status = null;

    public Export errorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
        return this;
    }

    @Schema(description="When the export generation fails, this attribute contains a description of the error.")
    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }

    public Export exportId(String exportId) {
        this.exportId = exportId;
        return this;
    }

    @Schema(description="The export identifier.")
    public String getExportId() {
        return this.exportId;
    }

    public void setExportId(String exportId) {
        this.exportId = exportId;
    }

    public Export generateExportFinishedAt(OffsetDateTime generateExportFinishedAt) {
        this.generateExportFinishedAt = generateExportFinishedAt;
        return this;
    }

    @Schema(description="The date and time when the export generation finished. Vales are in [ISO 8601](https://developer-docs.amazon.com/sp-api/docs/iso-8601) date-time format.")
    public OffsetDateTime getGenerateExportFinishedAt() {
        return this.generateExportFinishedAt;
    }

    public void setGenerateExportFinishedAt(OffsetDateTime generateExportFinishedAt) {
        this.generateExportFinishedAt = generateExportFinishedAt;
    }

    public Export generateExportStartedAt(OffsetDateTime generateExportStartedAt) {
        this.generateExportStartedAt = generateExportStartedAt;
        return this;
    }

    @Schema(description="The date and time when the export generation started. Values are in [ISO 8601](https://developer-docs.amazon.com/sp-api/docs/iso-8601) date-time format.")
    public OffsetDateTime getGenerateExportStartedAt() {
        return this.generateExportStartedAt;
    }

    public void setGenerateExportStartedAt(OffsetDateTime generateExportStartedAt) {
        this.generateExportStartedAt = generateExportStartedAt;
    }

    public Export invoicesDocumentIds(List<String> invoicesDocumentIds) {
        this.invoicesDocumentIds = invoicesDocumentIds;
        return this;
    }

    public Export addInvoicesDocumentIdsItem(String invoicesDocumentIdsItem) {
        if (this.invoicesDocumentIds == null) {
            this.invoicesDocumentIds = new ArrayList<String>();
        }
        this.invoicesDocumentIds.add(invoicesDocumentIdsItem);
        return this;
    }

    @Schema(description="The identifier for the export documents. To get the information required to retrieve the export document's contents, pass each ID in the `getInvoicesDocument` operation.  This list is empty until the status is `DONE`.")
    public List<String> getInvoicesDocumentIds() {
        return this.invoicesDocumentIds;
    }

    public void setInvoicesDocumentIds(List<String> invoicesDocumentIds) {
        this.invoicesDocumentIds = invoicesDocumentIds;
    }

    public Export status(ExportStatus status) {
        this.status = status;
        return this;
    }

    @Schema(description="")
    public ExportStatus getStatus() {
        return this.status;
    }

    public void setStatus(ExportStatus status) {
        this.status = status;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Export export = (Export)o;
        return Objects.equals(this.errorMessage, export.errorMessage) && Objects.equals(this.exportId, export.exportId) && Objects.equals(this.generateExportFinishedAt, export.generateExportFinishedAt) && Objects.equals(this.generateExportStartedAt, export.generateExportStartedAt) && Objects.equals(this.invoicesDocumentIds, export.invoicesDocumentIds) && Objects.equals((Object)this.status, (Object)export.status);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.errorMessage, this.exportId, this.generateExportFinishedAt, this.generateExportStartedAt, this.invoicesDocumentIds, this.status});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Export {\n");
        sb.append("    errorMessage: ").append(this.toIndentedString(this.errorMessage)).append("\n");
        sb.append("    exportId: ").append(this.toIndentedString(this.exportId)).append("\n");
        sb.append("    generateExportFinishedAt: ").append(this.toIndentedString(this.generateExportFinishedAt)).append("\n");
        sb.append("    generateExportStartedAt: ").append(this.toIndentedString(this.generateExportStartedAt)).append("\n");
        sb.append("    invoicesDocumentIds: ").append(this.toIndentedString(this.invoicesDocumentIds)).append("\n");
        sb.append("    status: ").append(this.toIndentedString((Object)this.status)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

