/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.fulfillment.outbound.v2020_07_01;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.threeten.bp.OffsetDateTime;
import software.amazon.spapi.models.fulfillment.outbound.v2020_07_01.Address;
import software.amazon.spapi.models.fulfillment.outbound.v2020_07_01.FeatureSettings;
import software.amazon.spapi.models.fulfillment.outbound.v2020_07_01.FulfillmentAction;
import software.amazon.spapi.models.fulfillment.outbound.v2020_07_01.FulfillmentPolicy;
import software.amazon.spapi.models.fulfillment.outbound.v2020_07_01.NotificationEmailList;
import software.amazon.spapi.models.fulfillment.outbound.v2020_07_01.ShippingSpeedCategory;
import software.amazon.spapi.models.fulfillment.outbound.v2020_07_01.UpdateFulfillmentOrderItemList;

@Schema(description="The request body schema for the `updateFulfillmentOrder` operation.")
public class UpdateFulfillmentOrderRequest {
    @SerializedName(value="marketplaceId")
    private String marketplaceId = null;
    @SerializedName(value="displayableOrderId")
    private String displayableOrderId = null;
    @SerializedName(value="displayableOrderDate")
    private OffsetDateTime displayableOrderDate = null;
    @SerializedName(value="displayableOrderComment")
    private String displayableOrderComment = null;
    @SerializedName(value="shippingSpeedCategory")
    private ShippingSpeedCategory shippingSpeedCategory = null;
    @SerializedName(value="destinationAddress")
    private Address destinationAddress = null;
    @SerializedName(value="fulfillmentAction")
    private FulfillmentAction fulfillmentAction = null;
    @SerializedName(value="fulfillmentPolicy")
    private FulfillmentPolicy fulfillmentPolicy = null;
    @SerializedName(value="shipFromCountryCode")
    private String shipFromCountryCode = null;
    @SerializedName(value="notificationEmails")
    private NotificationEmailList notificationEmails = null;
    @SerializedName(value="featureConstraints")
    private List<FeatureSettings> featureConstraints = null;
    @SerializedName(value="items")
    private UpdateFulfillmentOrderItemList items = null;

    public UpdateFulfillmentOrderRequest marketplaceId(String marketplaceId) {
        this.marketplaceId = marketplaceId;
        return this;
    }

    @Schema(description="The marketplace the fulfillment order is placed against.")
    public String getMarketplaceId() {
        return this.marketplaceId;
    }

    public void setMarketplaceId(String marketplaceId) {
        this.marketplaceId = marketplaceId;
    }

    public UpdateFulfillmentOrderRequest displayableOrderId(String displayableOrderId) {
        this.displayableOrderId = displayableOrderId;
        return this;
    }

    @Schema(description="A fulfillment order identifier that the seller creates. This value displays as the order identifier in recipient-facing materials such as the outbound shipment packing slip. The value of `DisplayableOrderId` should match the order identifier that the seller provides to the recipient. The seller can use the `SellerFulfillmentOrderId` for this value or they can specify an alternate value if they want the recipient to reference an alternate order identifier.")
    public String getDisplayableOrderId() {
        return this.displayableOrderId;
    }

    public void setDisplayableOrderId(String displayableOrderId) {
        this.displayableOrderId = displayableOrderId;
    }

    public UpdateFulfillmentOrderRequest displayableOrderDate(OffsetDateTime displayableOrderDate) {
        this.displayableOrderDate = displayableOrderDate;
        return this;
    }

    @Schema(description="")
    public OffsetDateTime getDisplayableOrderDate() {
        return this.displayableOrderDate;
    }

    public void setDisplayableOrderDate(OffsetDateTime displayableOrderDate) {
        this.displayableOrderDate = displayableOrderDate;
    }

    public UpdateFulfillmentOrderRequest displayableOrderComment(String displayableOrderComment) {
        this.displayableOrderComment = displayableOrderComment;
        return this;
    }

    @Schema(description="Order-specific text that appears in recipient-facing materials such as the outbound shipment packing slip.")
    public String getDisplayableOrderComment() {
        return this.displayableOrderComment;
    }

    public void setDisplayableOrderComment(String displayableOrderComment) {
        this.displayableOrderComment = displayableOrderComment;
    }

    public UpdateFulfillmentOrderRequest shippingSpeedCategory(ShippingSpeedCategory shippingSpeedCategory) {
        this.shippingSpeedCategory = shippingSpeedCategory;
        return this;
    }

    @Schema(description="")
    public ShippingSpeedCategory getShippingSpeedCategory() {
        return this.shippingSpeedCategory;
    }

    public void setShippingSpeedCategory(ShippingSpeedCategory shippingSpeedCategory) {
        this.shippingSpeedCategory = shippingSpeedCategory;
    }

    public UpdateFulfillmentOrderRequest destinationAddress(Address destinationAddress) {
        this.destinationAddress = destinationAddress;
        return this;
    }

    @Schema(description="")
    public Address getDestinationAddress() {
        return this.destinationAddress;
    }

    public void setDestinationAddress(Address destinationAddress) {
        this.destinationAddress = destinationAddress;
    }

    public UpdateFulfillmentOrderRequest fulfillmentAction(FulfillmentAction fulfillmentAction) {
        this.fulfillmentAction = fulfillmentAction;
        return this;
    }

    @Schema(description="")
    public FulfillmentAction getFulfillmentAction() {
        return this.fulfillmentAction;
    }

    public void setFulfillmentAction(FulfillmentAction fulfillmentAction) {
        this.fulfillmentAction = fulfillmentAction;
    }

    public UpdateFulfillmentOrderRequest fulfillmentPolicy(FulfillmentPolicy fulfillmentPolicy) {
        this.fulfillmentPolicy = fulfillmentPolicy;
        return this;
    }

    @Schema(description="")
    public FulfillmentPolicy getFulfillmentPolicy() {
        return this.fulfillmentPolicy;
    }

    public void setFulfillmentPolicy(FulfillmentPolicy fulfillmentPolicy) {
        this.fulfillmentPolicy = fulfillmentPolicy;
    }

    public UpdateFulfillmentOrderRequest shipFromCountryCode(String shipFromCountryCode) {
        this.shipFromCountryCode = shipFromCountryCode;
        return this;
    }

    @Schema(description="The two-character country code for the country from which the fulfillment order ships. Must be in ISO 3166-1 alpha-2 format.")
    public String getShipFromCountryCode() {
        return this.shipFromCountryCode;
    }

    public void setShipFromCountryCode(String shipFromCountryCode) {
        this.shipFromCountryCode = shipFromCountryCode;
    }

    public UpdateFulfillmentOrderRequest notificationEmails(NotificationEmailList notificationEmails) {
        this.notificationEmails = notificationEmails;
        return this;
    }

    @Schema(description="")
    public NotificationEmailList getNotificationEmails() {
        return this.notificationEmails;
    }

    public void setNotificationEmails(NotificationEmailList notificationEmails) {
        this.notificationEmails = notificationEmails;
    }

    public UpdateFulfillmentOrderRequest featureConstraints(List<FeatureSettings> featureConstraints) {
        this.featureConstraints = featureConstraints;
        return this;
    }

    public UpdateFulfillmentOrderRequest addFeatureConstraintsItem(FeatureSettings featureConstraintsItem) {
        if (this.featureConstraints == null) {
            this.featureConstraints = new ArrayList<FeatureSettings>();
        }
        this.featureConstraints.add(featureConstraintsItem);
        return this;
    }

    @Schema(description="A list of features and their fulfillment policies to apply to the order.")
    public List<FeatureSettings> getFeatureConstraints() {
        return this.featureConstraints;
    }

    public void setFeatureConstraints(List<FeatureSettings> featureConstraints) {
        this.featureConstraints = featureConstraints;
    }

    public UpdateFulfillmentOrderRequest items(UpdateFulfillmentOrderItemList items) {
        this.items = items;
        return this;
    }

    @Schema(description="")
    public UpdateFulfillmentOrderItemList getItems() {
        return this.items;
    }

    public void setItems(UpdateFulfillmentOrderItemList items) {
        this.items = items;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UpdateFulfillmentOrderRequest updateFulfillmentOrderRequest = (UpdateFulfillmentOrderRequest)o;
        return Objects.equals(this.marketplaceId, updateFulfillmentOrderRequest.marketplaceId) && Objects.equals(this.displayableOrderId, updateFulfillmentOrderRequest.displayableOrderId) && Objects.equals(this.displayableOrderDate, updateFulfillmentOrderRequest.displayableOrderDate) && Objects.equals(this.displayableOrderComment, updateFulfillmentOrderRequest.displayableOrderComment) && Objects.equals((Object)this.shippingSpeedCategory, (Object)updateFulfillmentOrderRequest.shippingSpeedCategory) && Objects.equals(this.destinationAddress, updateFulfillmentOrderRequest.destinationAddress) && Objects.equals((Object)this.fulfillmentAction, (Object)updateFulfillmentOrderRequest.fulfillmentAction) && Objects.equals((Object)this.fulfillmentPolicy, (Object)updateFulfillmentOrderRequest.fulfillmentPolicy) && Objects.equals(this.shipFromCountryCode, updateFulfillmentOrderRequest.shipFromCountryCode) && Objects.equals(this.notificationEmails, updateFulfillmentOrderRequest.notificationEmails) && Objects.equals(this.featureConstraints, updateFulfillmentOrderRequest.featureConstraints) && Objects.equals(this.items, updateFulfillmentOrderRequest.items);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.marketplaceId, this.displayableOrderId, this.displayableOrderDate, this.displayableOrderComment, this.shippingSpeedCategory, this.destinationAddress, this.fulfillmentAction, this.fulfillmentPolicy, this.shipFromCountryCode, this.notificationEmails, this.featureConstraints, this.items});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UpdateFulfillmentOrderRequest {\n");
        sb.append("    marketplaceId: ").append(this.toIndentedString(this.marketplaceId)).append("\n");
        sb.append("    displayableOrderId: ").append(this.toIndentedString(this.displayableOrderId)).append("\n");
        sb.append("    displayableOrderDate: ").append(this.toIndentedString(this.displayableOrderDate)).append("\n");
        sb.append("    displayableOrderComment: ").append(this.toIndentedString(this.displayableOrderComment)).append("\n");
        sb.append("    shippingSpeedCategory: ").append(this.toIndentedString((Object)this.shippingSpeedCategory)).append("\n");
        sb.append("    destinationAddress: ").append(this.toIndentedString(this.destinationAddress)).append("\n");
        sb.append("    fulfillmentAction: ").append(this.toIndentedString((Object)this.fulfillmentAction)).append("\n");
        sb.append("    fulfillmentPolicy: ").append(this.toIndentedString((Object)this.fulfillmentPolicy)).append("\n");
        sb.append("    shipFromCountryCode: ").append(this.toIndentedString(this.shipFromCountryCode)).append("\n");
        sb.append("    notificationEmails: ").append(this.toIndentedString(this.notificationEmails)).append("\n");
        sb.append("    featureConstraints: ").append(this.toIndentedString(this.featureConstraints)).append("\n");
        sb.append("    items: ").append(this.toIndentedString(this.items)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

