/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.fulfillment.outbound.v2020_07_01;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import org.threeten.bp.OffsetDateTime;
import software.amazon.spapi.models.fulfillment.outbound.v2020_07_01.EventCode;
import software.amazon.spapi.models.fulfillment.outbound.v2020_07_01.TrackingAddress;

@Schema(description="Information for tracking package deliveries.")
public class TrackingEvent {
    @SerializedName(value="eventDate")
    private OffsetDateTime eventDate = null;
    @SerializedName(value="eventAddress")
    private TrackingAddress eventAddress = null;
    @SerializedName(value="eventCode")
    private EventCode eventCode = null;
    @SerializedName(value="eventDescription")
    private String eventDescription = null;

    public TrackingEvent eventDate(OffsetDateTime eventDate) {
        this.eventDate = eventDate;
        return this;
    }

    @Schema(required=true, description="")
    public OffsetDateTime getEventDate() {
        return this.eventDate;
    }

    public void setEventDate(OffsetDateTime eventDate) {
        this.eventDate = eventDate;
    }

    public TrackingEvent eventAddress(TrackingAddress eventAddress) {
        this.eventAddress = eventAddress;
        return this;
    }

    @Schema(required=true, description="")
    public TrackingAddress getEventAddress() {
        return this.eventAddress;
    }

    public void setEventAddress(TrackingAddress eventAddress) {
        this.eventAddress = eventAddress;
    }

    public TrackingEvent eventCode(EventCode eventCode) {
        this.eventCode = eventCode;
        return this;
    }

    @Schema(required=true, description="")
    public EventCode getEventCode() {
        return this.eventCode;
    }

    public void setEventCode(EventCode eventCode) {
        this.eventCode = eventCode;
    }

    public TrackingEvent eventDescription(String eventDescription) {
        this.eventDescription = eventDescription;
        return this;
    }

    @Schema(required=true, description="A description for the corresponding event code.")
    public String getEventDescription() {
        return this.eventDescription;
    }

    public void setEventDescription(String eventDescription) {
        this.eventDescription = eventDescription;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TrackingEvent trackingEvent = (TrackingEvent)o;
        return Objects.equals(this.eventDate, trackingEvent.eventDate) && Objects.equals(this.eventAddress, trackingEvent.eventAddress) && Objects.equals((Object)this.eventCode, (Object)trackingEvent.eventCode) && Objects.equals(this.eventDescription, trackingEvent.eventDescription);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.eventDate, this.eventAddress, this.eventCode, this.eventDescription});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TrackingEvent {\n");
        sb.append("    eventDate: ").append(this.toIndentedString(this.eventDate)).append("\n");
        sb.append("    eventAddress: ").append(this.toIndentedString(this.eventAddress)).append("\n");
        sb.append("    eventCode: ").append(this.toIndentedString((Object)this.eventCode)).append("\n");
        sb.append("    eventDescription: ").append(this.toIndentedString(this.eventDescription)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

