/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.fulfillment.outbound.v2020_07_01;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import software.amazon.spapi.models.fulfillment.outbound.v2020_07_01.DeliveryWindowList;

@Schema(description="Delivery information for a scheduled delivery. This is only available in the JP marketplace.")
public class ScheduledDeliveryInfo {
    @SerializedName(value="deliveryTimeZone")
    private String deliveryTimeZone = null;
    @SerializedName(value="deliveryWindows")
    private DeliveryWindowList deliveryWindows = null;

    public ScheduledDeliveryInfo deliveryTimeZone(String deliveryTimeZone) {
        this.deliveryTimeZone = deliveryTimeZone;
        return this;
    }

    @Schema(required=true, description="The time zone of the destination address for the fulfillment order preview. Must be an IANA time zone name. Example: Asia/Tokyo.")
    public String getDeliveryTimeZone() {
        return this.deliveryTimeZone;
    }

    public void setDeliveryTimeZone(String deliveryTimeZone) {
        this.deliveryTimeZone = deliveryTimeZone;
    }

    public ScheduledDeliveryInfo deliveryWindows(DeliveryWindowList deliveryWindows) {
        this.deliveryWindows = deliveryWindows;
        return this;
    }

    @Schema(required=true, description="")
    public DeliveryWindowList getDeliveryWindows() {
        return this.deliveryWindows;
    }

    public void setDeliveryWindows(DeliveryWindowList deliveryWindows) {
        this.deliveryWindows = deliveryWindows;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScheduledDeliveryInfo scheduledDeliveryInfo = (ScheduledDeliveryInfo)o;
        return Objects.equals(this.deliveryTimeZone, scheduledDeliveryInfo.deliveryTimeZone) && Objects.equals(this.deliveryWindows, scheduledDeliveryInfo.deliveryWindows);
    }

    public int hashCode() {
        return Objects.hash(this.deliveryTimeZone, this.deliveryWindows);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ScheduledDeliveryInfo {\n");
        sb.append("    deliveryTimeZone: ").append(this.toIndentedString(this.deliveryTimeZone)).append("\n");
        sb.append("    deliveryWindows: ").append(this.toIndentedString(this.deliveryWindows)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

