/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.fulfillment.outbound.v2020_07_01;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import org.threeten.bp.OffsetDateTime;
import software.amazon.spapi.models.fulfillment.outbound.v2020_07_01.AdditionalLocationInfo;
import software.amazon.spapi.models.fulfillment.outbound.v2020_07_01.CurrentStatus;
import software.amazon.spapi.models.fulfillment.outbound.v2020_07_01.DateRange;
import software.amazon.spapi.models.fulfillment.outbound.v2020_07_01.TrackingAddress;
import software.amazon.spapi.models.fulfillment.outbound.v2020_07_01.TrackingEventList;

@Schema(description="Tracking details of package")
public class PackageTrackingDetails {
    @SerializedName(value="packageNumber")
    private Integer packageNumber = null;
    @SerializedName(value="trackingNumber")
    private String trackingNumber = null;
    @SerializedName(value="customerTrackingLink")
    private String customerTrackingLink = null;
    @SerializedName(value="carrierCode")
    private String carrierCode = null;
    @SerializedName(value="carrierPhoneNumber")
    private String carrierPhoneNumber = null;
    @SerializedName(value="carrierURL")
    private String carrierURL = null;
    @SerializedName(value="shipDate")
    private OffsetDateTime shipDate = null;
    @SerializedName(value="estimatedArrivalDate")
    private OffsetDateTime estimatedArrivalDate = null;
    @SerializedName(value="shipToAddress")
    private TrackingAddress shipToAddress = null;
    @SerializedName(value="currentStatus")
    private CurrentStatus currentStatus = null;
    @SerializedName(value="currentStatusDescription")
    private String currentStatusDescription = null;
    @SerializedName(value="deliveryWindow")
    private DateRange deliveryWindow = null;
    @SerializedName(value="signedForBy")
    private String signedForBy = null;
    @SerializedName(value="additionalLocationInfo")
    private AdditionalLocationInfo additionalLocationInfo = null;
    @SerializedName(value="trackingEvents")
    private TrackingEventList trackingEvents = null;

    public PackageTrackingDetails packageNumber(Integer packageNumber) {
        this.packageNumber = packageNumber;
        return this;
    }

    @Schema(required=true, description="The package identifier.")
    public Integer getPackageNumber() {
        return this.packageNumber;
    }

    public void setPackageNumber(Integer packageNumber) {
        this.packageNumber = packageNumber;
    }

    public PackageTrackingDetails trackingNumber(String trackingNumber) {
        this.trackingNumber = trackingNumber;
        return this;
    }

    @Schema(description="The tracking number for the package.")
    public String getTrackingNumber() {
        return this.trackingNumber;
    }

    public void setTrackingNumber(String trackingNumber) {
        this.trackingNumber = trackingNumber;
    }

    public PackageTrackingDetails customerTrackingLink(String customerTrackingLink) {
        this.customerTrackingLink = customerTrackingLink;
        return this;
    }

    @Schema(description="Link on swiship.com that allows customers to track the package.")
    public String getCustomerTrackingLink() {
        return this.customerTrackingLink;
    }

    public void setCustomerTrackingLink(String customerTrackingLink) {
        this.customerTrackingLink = customerTrackingLink;
    }

    public PackageTrackingDetails carrierCode(String carrierCode) {
        this.carrierCode = carrierCode;
        return this;
    }

    @Schema(description="The name of the carrier.")
    public String getCarrierCode() {
        return this.carrierCode;
    }

    public void setCarrierCode(String carrierCode) {
        this.carrierCode = carrierCode;
    }

    public PackageTrackingDetails carrierPhoneNumber(String carrierPhoneNumber) {
        this.carrierPhoneNumber = carrierPhoneNumber;
        return this;
    }

    @Schema(description="The phone number of the carrier.")
    public String getCarrierPhoneNumber() {
        return this.carrierPhoneNumber;
    }

    public void setCarrierPhoneNumber(String carrierPhoneNumber) {
        this.carrierPhoneNumber = carrierPhoneNumber;
    }

    public PackageTrackingDetails carrierURL(String carrierURL) {
        this.carrierURL = carrierURL;
        return this;
    }

    @Schema(description="The URL of the carrier's website.")
    public String getCarrierURL() {
        return this.carrierURL;
    }

    public void setCarrierURL(String carrierURL) {
        this.carrierURL = carrierURL;
    }

    public PackageTrackingDetails shipDate(OffsetDateTime shipDate) {
        this.shipDate = shipDate;
        return this;
    }

    @Schema(description="")
    public OffsetDateTime getShipDate() {
        return this.shipDate;
    }

    public void setShipDate(OffsetDateTime shipDate) {
        this.shipDate = shipDate;
    }

    public PackageTrackingDetails estimatedArrivalDate(OffsetDateTime estimatedArrivalDate) {
        this.estimatedArrivalDate = estimatedArrivalDate;
        return this;
    }

    @Schema(description="")
    public OffsetDateTime getEstimatedArrivalDate() {
        return this.estimatedArrivalDate;
    }

    public void setEstimatedArrivalDate(OffsetDateTime estimatedArrivalDate) {
        this.estimatedArrivalDate = estimatedArrivalDate;
    }

    public PackageTrackingDetails shipToAddress(TrackingAddress shipToAddress) {
        this.shipToAddress = shipToAddress;
        return this;
    }

    @Schema(description="")
    public TrackingAddress getShipToAddress() {
        return this.shipToAddress;
    }

    public void setShipToAddress(TrackingAddress shipToAddress) {
        this.shipToAddress = shipToAddress;
    }

    public PackageTrackingDetails currentStatus(CurrentStatus currentStatus) {
        this.currentStatus = currentStatus;
        return this;
    }

    @Schema(description="")
    public CurrentStatus getCurrentStatus() {
        return this.currentStatus;
    }

    public void setCurrentStatus(CurrentStatus currentStatus) {
        this.currentStatus = currentStatus;
    }

    public PackageTrackingDetails currentStatusDescription(String currentStatusDescription) {
        this.currentStatusDescription = currentStatusDescription;
        return this;
    }

    @Schema(description="Description corresponding to the `CurrentStatus` value.")
    public String getCurrentStatusDescription() {
        return this.currentStatusDescription;
    }

    public void setCurrentStatusDescription(String currentStatusDescription) {
        this.currentStatusDescription = currentStatusDescription;
    }

    public PackageTrackingDetails deliveryWindow(DateRange deliveryWindow) {
        this.deliveryWindow = deliveryWindow;
        return this;
    }

    @Schema(description="")
    public DateRange getDeliveryWindow() {
        return this.deliveryWindow;
    }

    public void setDeliveryWindow(DateRange deliveryWindow) {
        this.deliveryWindow = deliveryWindow;
    }

    public PackageTrackingDetails signedForBy(String signedForBy) {
        this.signedForBy = signedForBy;
        return this;
    }

    @Schema(description="The name of the person who signed for the package.")
    public String getSignedForBy() {
        return this.signedForBy;
    }

    public void setSignedForBy(String signedForBy) {
        this.signedForBy = signedForBy;
    }

    public PackageTrackingDetails additionalLocationInfo(AdditionalLocationInfo additionalLocationInfo) {
        this.additionalLocationInfo = additionalLocationInfo;
        return this;
    }

    @Schema(description="")
    public AdditionalLocationInfo getAdditionalLocationInfo() {
        return this.additionalLocationInfo;
    }

    public void setAdditionalLocationInfo(AdditionalLocationInfo additionalLocationInfo) {
        this.additionalLocationInfo = additionalLocationInfo;
    }

    public PackageTrackingDetails trackingEvents(TrackingEventList trackingEvents) {
        this.trackingEvents = trackingEvents;
        return this;
    }

    @Schema(description="")
    public TrackingEventList getTrackingEvents() {
        return this.trackingEvents;
    }

    public void setTrackingEvents(TrackingEventList trackingEvents) {
        this.trackingEvents = trackingEvents;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PackageTrackingDetails packageTrackingDetails = (PackageTrackingDetails)o;
        return Objects.equals(this.packageNumber, packageTrackingDetails.packageNumber) && Objects.equals(this.trackingNumber, packageTrackingDetails.trackingNumber) && Objects.equals(this.customerTrackingLink, packageTrackingDetails.customerTrackingLink) && Objects.equals(this.carrierCode, packageTrackingDetails.carrierCode) && Objects.equals(this.carrierPhoneNumber, packageTrackingDetails.carrierPhoneNumber) && Objects.equals(this.carrierURL, packageTrackingDetails.carrierURL) && Objects.equals(this.shipDate, packageTrackingDetails.shipDate) && Objects.equals(this.estimatedArrivalDate, packageTrackingDetails.estimatedArrivalDate) && Objects.equals(this.shipToAddress, packageTrackingDetails.shipToAddress) && Objects.equals((Object)this.currentStatus, (Object)packageTrackingDetails.currentStatus) && Objects.equals(this.currentStatusDescription, packageTrackingDetails.currentStatusDescription) && Objects.equals(this.deliveryWindow, packageTrackingDetails.deliveryWindow) && Objects.equals(this.signedForBy, packageTrackingDetails.signedForBy) && Objects.equals((Object)this.additionalLocationInfo, (Object)packageTrackingDetails.additionalLocationInfo) && Objects.equals(this.trackingEvents, packageTrackingDetails.trackingEvents);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.packageNumber, this.trackingNumber, this.customerTrackingLink, this.carrierCode, this.carrierPhoneNumber, this.carrierURL, this.shipDate, this.estimatedArrivalDate, this.shipToAddress, this.currentStatus, this.currentStatusDescription, this.deliveryWindow, this.signedForBy, this.additionalLocationInfo, this.trackingEvents});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PackageTrackingDetails {\n");
        sb.append("    packageNumber: ").append(this.toIndentedString(this.packageNumber)).append("\n");
        sb.append("    trackingNumber: ").append(this.toIndentedString(this.trackingNumber)).append("\n");
        sb.append("    customerTrackingLink: ").append(this.toIndentedString(this.customerTrackingLink)).append("\n");
        sb.append("    carrierCode: ").append(this.toIndentedString(this.carrierCode)).append("\n");
        sb.append("    carrierPhoneNumber: ").append(this.toIndentedString(this.carrierPhoneNumber)).append("\n");
        sb.append("    carrierURL: ").append(this.toIndentedString(this.carrierURL)).append("\n");
        sb.append("    shipDate: ").append(this.toIndentedString(this.shipDate)).append("\n");
        sb.append("    estimatedArrivalDate: ").append(this.toIndentedString(this.estimatedArrivalDate)).append("\n");
        sb.append("    shipToAddress: ").append(this.toIndentedString(this.shipToAddress)).append("\n");
        sb.append("    currentStatus: ").append(this.toIndentedString((Object)this.currentStatus)).append("\n");
        sb.append("    currentStatusDescription: ").append(this.toIndentedString(this.currentStatusDescription)).append("\n");
        sb.append("    deliveryWindow: ").append(this.toIndentedString(this.deliveryWindow)).append("\n");
        sb.append("    signedForBy: ").append(this.toIndentedString(this.signedForBy)).append("\n");
        sb.append("    additionalLocationInfo: ").append(this.toIndentedString((Object)this.additionalLocationInfo)).append("\n");
        sb.append("    trackingEvents: ").append(this.toIndentedString(this.trackingEvents)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

