/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.fulfillment.outbound.v2020_07_01;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import org.threeten.bp.OffsetDateTime;
import software.amazon.spapi.models.fulfillment.outbound.v2020_07_01.DeliveryInformation;
import software.amazon.spapi.models.fulfillment.outbound.v2020_07_01.LockerDetails;

@Schema(description="Package information for a shipment in a fulfillment order.")
public class FulfillmentShipmentPackage {
    @SerializedName(value="packageNumber")
    private Integer packageNumber = null;
    @SerializedName(value="carrierCode")
    private String carrierCode = null;
    @SerializedName(value="trackingNumber")
    private String trackingNumber = null;
    @SerializedName(value="amazonFulfillmentTrackingNumber")
    private String amazonFulfillmentTrackingNumber = null;
    @SerializedName(value="estimatedArrivalDate")
    private OffsetDateTime estimatedArrivalDate = null;
    @SerializedName(value="lockerDetails")
    private LockerDetails lockerDetails = null;
    @SerializedName(value="deliveryInformation")
    private DeliveryInformation deliveryInformation = null;

    public FulfillmentShipmentPackage packageNumber(Integer packageNumber) {
        this.packageNumber = packageNumber;
        return this;
    }

    @Schema(required=true, description="Identifies a package in a shipment.")
    public Integer getPackageNumber() {
        return this.packageNumber;
    }

    public void setPackageNumber(Integer packageNumber) {
        this.packageNumber = packageNumber;
    }

    public FulfillmentShipmentPackage carrierCode(String carrierCode) {
        this.carrierCode = carrierCode;
        return this;
    }

    @Schema(required=true, description="Identifies the carrier who will deliver the shipment to the recipient.")
    public String getCarrierCode() {
        return this.carrierCode;
    }

    public void setCarrierCode(String carrierCode) {
        this.carrierCode = carrierCode;
    }

    public FulfillmentShipmentPackage trackingNumber(String trackingNumber) {
        this.trackingNumber = trackingNumber;
        return this;
    }

    @Schema(description="The tracking number, if provided, can be used to obtain tracking and delivery information.")
    public String getTrackingNumber() {
        return this.trackingNumber;
    }

    public void setTrackingNumber(String trackingNumber) {
        this.trackingNumber = trackingNumber;
    }

    public FulfillmentShipmentPackage amazonFulfillmentTrackingNumber(String amazonFulfillmentTrackingNumber) {
        this.amazonFulfillmentTrackingNumber = amazonFulfillmentTrackingNumber;
        return this;
    }

    @Schema(description="The Amazon fulfillment tracking number, if provided, can be used to obtain tracking and delivery information.")
    public String getAmazonFulfillmentTrackingNumber() {
        return this.amazonFulfillmentTrackingNumber;
    }

    public void setAmazonFulfillmentTrackingNumber(String amazonFulfillmentTrackingNumber) {
        this.amazonFulfillmentTrackingNumber = amazonFulfillmentTrackingNumber;
    }

    public FulfillmentShipmentPackage estimatedArrivalDate(OffsetDateTime estimatedArrivalDate) {
        this.estimatedArrivalDate = estimatedArrivalDate;
        return this;
    }

    @Schema(description="")
    public OffsetDateTime getEstimatedArrivalDate() {
        return this.estimatedArrivalDate;
    }

    public void setEstimatedArrivalDate(OffsetDateTime estimatedArrivalDate) {
        this.estimatedArrivalDate = estimatedArrivalDate;
    }

    public FulfillmentShipmentPackage lockerDetails(LockerDetails lockerDetails) {
        this.lockerDetails = lockerDetails;
        return this;
    }

    @Schema(description="")
    public LockerDetails getLockerDetails() {
        return this.lockerDetails;
    }

    public void setLockerDetails(LockerDetails lockerDetails) {
        this.lockerDetails = lockerDetails;
    }

    public FulfillmentShipmentPackage deliveryInformation(DeliveryInformation deliveryInformation) {
        this.deliveryInformation = deliveryInformation;
        return this;
    }

    @Schema(description="")
    public DeliveryInformation getDeliveryInformation() {
        return this.deliveryInformation;
    }

    public void setDeliveryInformation(DeliveryInformation deliveryInformation) {
        this.deliveryInformation = deliveryInformation;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FulfillmentShipmentPackage fulfillmentShipmentPackage = (FulfillmentShipmentPackage)o;
        return Objects.equals(this.packageNumber, fulfillmentShipmentPackage.packageNumber) && Objects.equals(this.carrierCode, fulfillmentShipmentPackage.carrierCode) && Objects.equals(this.trackingNumber, fulfillmentShipmentPackage.trackingNumber) && Objects.equals(this.amazonFulfillmentTrackingNumber, fulfillmentShipmentPackage.amazonFulfillmentTrackingNumber) && Objects.equals(this.estimatedArrivalDate, fulfillmentShipmentPackage.estimatedArrivalDate) && Objects.equals(this.lockerDetails, fulfillmentShipmentPackage.lockerDetails) && Objects.equals(this.deliveryInformation, fulfillmentShipmentPackage.deliveryInformation);
    }

    public int hashCode() {
        return Objects.hash(this.packageNumber, this.carrierCode, this.trackingNumber, this.amazonFulfillmentTrackingNumber, this.estimatedArrivalDate, this.lockerDetails, this.deliveryInformation);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FulfillmentShipmentPackage {\n");
        sb.append("    packageNumber: ").append(this.toIndentedString(this.packageNumber)).append("\n");
        sb.append("    carrierCode: ").append(this.toIndentedString(this.carrierCode)).append("\n");
        sb.append("    trackingNumber: ").append(this.toIndentedString(this.trackingNumber)).append("\n");
        sb.append("    amazonFulfillmentTrackingNumber: ").append(this.toIndentedString(this.amazonFulfillmentTrackingNumber)).append("\n");
        sb.append("    estimatedArrivalDate: ").append(this.toIndentedString(this.estimatedArrivalDate)).append("\n");
        sb.append("    lockerDetails: ").append(this.toIndentedString(this.lockerDetails)).append("\n");
        sb.append("    deliveryInformation: ").append(this.toIndentedString(this.deliveryInformation)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

