/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.fulfillment.outbound.v2020_07_01;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import software.amazon.spapi.models.fulfillment.outbound.v2020_07_01.FeatureSettings;
import software.amazon.spapi.models.fulfillment.outbound.v2020_07_01.FeeList;
import software.amazon.spapi.models.fulfillment.outbound.v2020_07_01.FulfillmentPreviewShipmentList;
import software.amazon.spapi.models.fulfillment.outbound.v2020_07_01.ScheduledDeliveryInfo;
import software.amazon.spapi.models.fulfillment.outbound.v2020_07_01.ShippingSpeedCategory;
import software.amazon.spapi.models.fulfillment.outbound.v2020_07_01.StringList;
import software.amazon.spapi.models.fulfillment.outbound.v2020_07_01.UnfulfillablePreviewItemList;
import software.amazon.spapi.models.fulfillment.outbound.v2020_07_01.Weight;

@Schema(description="Information about a fulfillment order preview, including delivery and fee information based on shipping method.")
public class FulfillmentPreview {
    @SerializedName(value="shippingSpeedCategory")
    private ShippingSpeedCategory shippingSpeedCategory = null;
    @SerializedName(value="scheduledDeliveryInfo")
    private ScheduledDeliveryInfo scheduledDeliveryInfo = null;
    @SerializedName(value="isFulfillable")
    private Boolean isFulfillable = null;
    @SerializedName(value="isCODCapable")
    private Boolean isCODCapable = null;
    @SerializedName(value="estimatedShippingWeight")
    private Weight estimatedShippingWeight = null;
    @SerializedName(value="estimatedFees")
    private FeeList estimatedFees = null;
    @SerializedName(value="fulfillmentPreviewShipments")
    private FulfillmentPreviewShipmentList fulfillmentPreviewShipments = null;
    @SerializedName(value="unfulfillablePreviewItems")
    private UnfulfillablePreviewItemList unfulfillablePreviewItems = null;
    @SerializedName(value="orderUnfulfillableReasons")
    private StringList orderUnfulfillableReasons = null;
    @SerializedName(value="marketplaceId")
    private String marketplaceId = null;
    @SerializedName(value="featureConstraints")
    private List<FeatureSettings> featureConstraints = null;

    public FulfillmentPreview shippingSpeedCategory(ShippingSpeedCategory shippingSpeedCategory) {
        this.shippingSpeedCategory = shippingSpeedCategory;
        return this;
    }

    @Schema(required=true, description="")
    public ShippingSpeedCategory getShippingSpeedCategory() {
        return this.shippingSpeedCategory;
    }

    public void setShippingSpeedCategory(ShippingSpeedCategory shippingSpeedCategory) {
        this.shippingSpeedCategory = shippingSpeedCategory;
    }

    public FulfillmentPreview scheduledDeliveryInfo(ScheduledDeliveryInfo scheduledDeliveryInfo) {
        this.scheduledDeliveryInfo = scheduledDeliveryInfo;
        return this;
    }

    @Schema(description="")
    public ScheduledDeliveryInfo getScheduledDeliveryInfo() {
        return this.scheduledDeliveryInfo;
    }

    public void setScheduledDeliveryInfo(ScheduledDeliveryInfo scheduledDeliveryInfo) {
        this.scheduledDeliveryInfo = scheduledDeliveryInfo;
    }

    public FulfillmentPreview isFulfillable(Boolean isFulfillable) {
        this.isFulfillable = isFulfillable;
        return this;
    }

    @Schema(required=true, description="When true, this fulfillment order preview is fulfillable.")
    public Boolean isIsFulfillable() {
        return this.isFulfillable;
    }

    public void setIsFulfillable(Boolean isFulfillable) {
        this.isFulfillable = isFulfillable;
    }

    public FulfillmentPreview isCODCapable(Boolean isCODCapable) {
        this.isCODCapable = isCODCapable;
        return this;
    }

    @Schema(required=true, description="When true, this fulfillment order preview is for COD (Cash On Delivery).")
    public Boolean isIsCODCapable() {
        return this.isCODCapable;
    }

    public void setIsCODCapable(Boolean isCODCapable) {
        this.isCODCapable = isCODCapable;
    }

    public FulfillmentPreview estimatedShippingWeight(Weight estimatedShippingWeight) {
        this.estimatedShippingWeight = estimatedShippingWeight;
        return this;
    }

    @Schema(description="")
    public Weight getEstimatedShippingWeight() {
        return this.estimatedShippingWeight;
    }

    public void setEstimatedShippingWeight(Weight estimatedShippingWeight) {
        this.estimatedShippingWeight = estimatedShippingWeight;
    }

    public FulfillmentPreview estimatedFees(FeeList estimatedFees) {
        this.estimatedFees = estimatedFees;
        return this;
    }

    @Schema(description="")
    public FeeList getEstimatedFees() {
        return this.estimatedFees;
    }

    public void setEstimatedFees(FeeList estimatedFees) {
        this.estimatedFees = estimatedFees;
    }

    public FulfillmentPreview fulfillmentPreviewShipments(FulfillmentPreviewShipmentList fulfillmentPreviewShipments) {
        this.fulfillmentPreviewShipments = fulfillmentPreviewShipments;
        return this;
    }

    @Schema(description="")
    public FulfillmentPreviewShipmentList getFulfillmentPreviewShipments() {
        return this.fulfillmentPreviewShipments;
    }

    public void setFulfillmentPreviewShipments(FulfillmentPreviewShipmentList fulfillmentPreviewShipments) {
        this.fulfillmentPreviewShipments = fulfillmentPreviewShipments;
    }

    public FulfillmentPreview unfulfillablePreviewItems(UnfulfillablePreviewItemList unfulfillablePreviewItems) {
        this.unfulfillablePreviewItems = unfulfillablePreviewItems;
        return this;
    }

    @Schema(description="")
    public UnfulfillablePreviewItemList getUnfulfillablePreviewItems() {
        return this.unfulfillablePreviewItems;
    }

    public void setUnfulfillablePreviewItems(UnfulfillablePreviewItemList unfulfillablePreviewItems) {
        this.unfulfillablePreviewItems = unfulfillablePreviewItems;
    }

    public FulfillmentPreview orderUnfulfillableReasons(StringList orderUnfulfillableReasons) {
        this.orderUnfulfillableReasons = orderUnfulfillableReasons;
        return this;
    }

    @Schema(description="")
    public StringList getOrderUnfulfillableReasons() {
        return this.orderUnfulfillableReasons;
    }

    public void setOrderUnfulfillableReasons(StringList orderUnfulfillableReasons) {
        this.orderUnfulfillableReasons = orderUnfulfillableReasons;
    }

    public FulfillmentPreview marketplaceId(String marketplaceId) {
        this.marketplaceId = marketplaceId;
        return this;
    }

    @Schema(required=true, description="The marketplace the fulfillment order is placed against.")
    public String getMarketplaceId() {
        return this.marketplaceId;
    }

    public void setMarketplaceId(String marketplaceId) {
        this.marketplaceId = marketplaceId;
    }

    public FulfillmentPreview featureConstraints(List<FeatureSettings> featureConstraints) {
        this.featureConstraints = featureConstraints;
        return this;
    }

    public FulfillmentPreview addFeatureConstraintsItem(FeatureSettings featureConstraintsItem) {
        if (this.featureConstraints == null) {
            this.featureConstraints = new ArrayList<FeatureSettings>();
        }
        this.featureConstraints.add(featureConstraintsItem);
        return this;
    }

    @Schema(description="A list of features and their fulfillment policies to apply to the order.")
    public List<FeatureSettings> getFeatureConstraints() {
        return this.featureConstraints;
    }

    public void setFeatureConstraints(List<FeatureSettings> featureConstraints) {
        this.featureConstraints = featureConstraints;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FulfillmentPreview fulfillmentPreview = (FulfillmentPreview)o;
        return Objects.equals((Object)this.shippingSpeedCategory, (Object)fulfillmentPreview.shippingSpeedCategory) && Objects.equals(this.scheduledDeliveryInfo, fulfillmentPreview.scheduledDeliveryInfo) && Objects.equals(this.isFulfillable, fulfillmentPreview.isFulfillable) && Objects.equals(this.isCODCapable, fulfillmentPreview.isCODCapable) && Objects.equals(this.estimatedShippingWeight, fulfillmentPreview.estimatedShippingWeight) && Objects.equals(this.estimatedFees, fulfillmentPreview.estimatedFees) && Objects.equals(this.fulfillmentPreviewShipments, fulfillmentPreview.fulfillmentPreviewShipments) && Objects.equals(this.unfulfillablePreviewItems, fulfillmentPreview.unfulfillablePreviewItems) && Objects.equals(this.orderUnfulfillableReasons, fulfillmentPreview.orderUnfulfillableReasons) && Objects.equals(this.marketplaceId, fulfillmentPreview.marketplaceId) && Objects.equals(this.featureConstraints, fulfillmentPreview.featureConstraints);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.shippingSpeedCategory, this.scheduledDeliveryInfo, this.isFulfillable, this.isCODCapable, this.estimatedShippingWeight, this.estimatedFees, this.fulfillmentPreviewShipments, this.unfulfillablePreviewItems, this.orderUnfulfillableReasons, this.marketplaceId, this.featureConstraints});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class FulfillmentPreview {\n");
        sb.append("    shippingSpeedCategory: ").append(this.toIndentedString((Object)this.shippingSpeedCategory)).append("\n");
        sb.append("    scheduledDeliveryInfo: ").append(this.toIndentedString(this.scheduledDeliveryInfo)).append("\n");
        sb.append("    isFulfillable: ").append(this.toIndentedString(this.isFulfillable)).append("\n");
        sb.append("    isCODCapable: ").append(this.toIndentedString(this.isCODCapable)).append("\n");
        sb.append("    estimatedShippingWeight: ").append(this.toIndentedString(this.estimatedShippingWeight)).append("\n");
        sb.append("    estimatedFees: ").append(this.toIndentedString(this.estimatedFees)).append("\n");
        sb.append("    fulfillmentPreviewShipments: ").append(this.toIndentedString(this.fulfillmentPreviewShipments)).append("\n");
        sb.append("    unfulfillablePreviewItems: ").append(this.toIndentedString(this.unfulfillablePreviewItems)).append("\n");
        sb.append("    orderUnfulfillableReasons: ").append(this.toIndentedString(this.orderUnfulfillableReasons)).append("\n");
        sb.append("    marketplaceId: ").append(this.toIndentedString(this.marketplaceId)).append("\n");
        sb.append("    featureConstraints: ").append(this.toIndentedString(this.featureConstraints)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

