/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.fulfillment.outbound.v2020_07_01;

import com.google.gson.TypeAdapter;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import io.swagger.v3.oas.annotations.media.Schema;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@Schema(description="The preferred location to leave packages at the destination address.")
public class DropOffLocation {
    @SerializedName(value="type")
    private TypeEnum type = null;
    @SerializedName(value="attributes")
    private Map<String, String> attributes = null;

    public DropOffLocation type(TypeEnum type) {
        this.type = type;
        return this;
    }

    @Schema(required=true, description="Specifies the preferred location to leave the package at the destination address.")
    public TypeEnum getType() {
        return this.type;
    }

    public void setType(TypeEnum type) {
        this.type = type;
    }

    public DropOffLocation attributes(Map<String, String> attributes) {
        this.attributes = attributes;
        return this;
    }

    public DropOffLocation putAttributesItem(String key, String attributesItem) {
        if (this.attributes == null) {
            this.attributes = new HashMap<String, String>();
        }
        this.attributes.put(key, attributesItem);
        return this;
    }

    @Schema(description="Additional information about the drop-off location that can vary depending on the type of drop-off location specified in the `type` field. If the `type` is set to `FALLBACK_NEIGHBOR_DELIVERY`, the `attributes` object should include the exact keys `neighborName` and `houseNumber` to provide the name and house number of the designated neighbor.")
    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Map<String, String> attributes) {
        this.attributes = attributes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DropOffLocation dropOffLocation = (DropOffLocation)o;
        return Objects.equals((Object)this.type, (Object)dropOffLocation.type) && Objects.equals(this.attributes, dropOffLocation.attributes);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.attributes});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DropOffLocation {\n");
        sb.append("    type: ").append(this.toIndentedString((Object)this.type)).append("\n");
        sb.append("    attributes: ").append(this.toIndentedString(this.attributes)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    @JsonAdapter(value=Adapter.class)
    public static enum TypeEnum {
        FRONT_DOOR("FRONT_DOOR"),
        DELIVERY_BOX("DELIVERY_BOX"),
        GAS_METER_BOX("GAS_METER_BOX"),
        BICYCLE_BASKET("BICYCLE_BASKET"),
        GARAGE("GARAGE"),
        RECEPTIONIST("RECEPTIONIST"),
        FALLBACK_NEIGHBOR_DELIVERY("FALLBACK_NEIGHBOR_DELIVERY"),
        DO_NOT_LEAVE_UNATTENDED("DO_NOT_LEAVE_UNATTENDED");

        private String value;

        private TypeEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static TypeEnum fromValue(String input) {
            for (TypeEnum b : TypeEnum.values()) {
                if (!b.value.equals(input)) continue;
                return b;
            }
            return null;
        }

        public static class Adapter
        extends TypeAdapter<TypeEnum> {
            public void write(JsonWriter jsonWriter, TypeEnum enumeration) throws IOException {
                jsonWriter.value(String.valueOf(enumeration.getValue()));
            }

            public TypeEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return TypeEnum.fromValue(value);
            }
        }
    }
}

