/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.fulfillment.outbound.v2020_07_01;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;

@Schema(description="A delivery document for a package.")
public class DeliveryDocument {
    @SerializedName(value="documentType")
    private String documentType = null;
    @SerializedName(value="url")
    private String url = null;

    public DeliveryDocument documentType(String documentType) {
        this.documentType = documentType;
        return this;
    }

    @Schema(required=true, description="The delivery document type. The only possible value is `DELIVERY_IMAGE`.")
    public String getDocumentType() {
        return this.documentType;
    }

    public void setDocumentType(String documentType) {
        this.documentType = documentType;
    }

    public DeliveryDocument url(String url) {
        this.url = url;
        return this;
    }

    @Schema(description="A URL that you can use to download the document. This URL has a `Content-Type` header. Note that the URL expires after one hour. To get a new URL, you must call the API again.")
    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DeliveryDocument deliveryDocument = (DeliveryDocument)o;
        return Objects.equals(this.documentType, deliveryDocument.documentType) && Objects.equals(this.url, deliveryDocument.url);
    }

    public int hashCode() {
        return Objects.hash(this.documentType, this.url);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class DeliveryDocument {\n");
        sb.append("    documentType: ").append(this.toIndentedString(this.documentType)).append("\n");
        sb.append("    url: ").append(this.toIndentedString(this.url)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

