/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.fulfillment.inbound.v2024_03_20;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import software.amazon.spapi.models.fulfillment.inbound.v2024_03_20.Carrier;
import software.amazon.spapi.models.fulfillment.inbound.v2024_03_20.CarrierAppointment;
import software.amazon.spapi.models.fulfillment.inbound.v2024_03_20.Quote;

@Schema(description="Contains information pertaining to a transportation option and the related carrier.")
public class TransportationOption {
    @SerializedName(value="carrier")
    private Carrier carrier = null;
    @SerializedName(value="carrierAppointment")
    private CarrierAppointment carrierAppointment = null;
    @SerializedName(value="preconditions")
    private List<String> preconditions = new ArrayList<String>();
    @SerializedName(value="quote")
    private Quote quote = null;
    @SerializedName(value="shipmentId")
    private String shipmentId = null;
    @SerializedName(value="shippingMode")
    private String shippingMode = null;
    @SerializedName(value="shippingSolution")
    private String shippingSolution = null;
    @SerializedName(value="transportationOptionId")
    private String transportationOptionId = null;

    public TransportationOption carrier(Carrier carrier) {
        this.carrier = carrier;
        return this;
    }

    @Schema(required=true, description="")
    public Carrier getCarrier() {
        return this.carrier;
    }

    public void setCarrier(Carrier carrier) {
        this.carrier = carrier;
    }

    public TransportationOption carrierAppointment(CarrierAppointment carrierAppointment) {
        this.carrierAppointment = carrierAppointment;
        return this;
    }

    @Schema(description="")
    public CarrierAppointment getCarrierAppointment() {
        return this.carrierAppointment;
    }

    public void setCarrierAppointment(CarrierAppointment carrierAppointment) {
        this.carrierAppointment = carrierAppointment;
    }

    public TransportationOption preconditions(List<String> preconditions) {
        this.preconditions = preconditions;
        return this;
    }

    public TransportationOption addPreconditionsItem(String preconditionsItem) {
        this.preconditions.add(preconditionsItem);
        return this;
    }

    @Schema(required=true, description="Identifies a list of preconditions for confirming the transportation option.")
    public List<String> getPreconditions() {
        return this.preconditions;
    }

    public void setPreconditions(List<String> preconditions) {
        this.preconditions = preconditions;
    }

    public TransportationOption quote(Quote quote) {
        this.quote = quote;
        return this;
    }

    @Schema(description="")
    public Quote getQuote() {
        return this.quote;
    }

    public void setQuote(Quote quote) {
        this.quote = quote;
    }

    public TransportationOption shipmentId(String shipmentId) {
        this.shipmentId = shipmentId;
        return this;
    }

    @Schema(required=true, description="Identifier of a shipment. A shipment contains the boxes and units being inbounded.")
    public String getShipmentId() {
        return this.shipmentId;
    }

    public void setShipmentId(String shipmentId) {
        this.shipmentId = shipmentId;
    }

    public TransportationOption shippingMode(String shippingMode) {
        this.shippingMode = shippingMode;
        return this;
    }

    @Schema(required=true, description="Mode of shipment transportation that this option will provide.  Possible values: `GROUND_SMALL_PARCEL`, `FREIGHT_LTL`, `FREIGHT_FTL_PALLET`, `FREIGHT_FTL_NONPALLET`, `OCEAN_LCL`, `OCEAN_FCL`, `AIR_SMALL_PARCEL`, `AIR_SMALL_PARCEL_EXPRESS`.")
    public String getShippingMode() {
        return this.shippingMode;
    }

    public void setShippingMode(String shippingMode) {
        this.shippingMode = shippingMode;
    }

    public TransportationOption shippingSolution(String shippingSolution) {
        this.shippingSolution = shippingSolution;
        return this;
    }

    @Schema(required=true, description="Shipping program for the option. Possible values: `AMAZON_PARTNERED_CARRIER`, `USE_YOUR_OWN_CARRIER`.")
    public String getShippingSolution() {
        return this.shippingSolution;
    }

    public void setShippingSolution(String shippingSolution) {
        this.shippingSolution = shippingSolution;
    }

    public TransportationOption transportationOptionId(String transportationOptionId) {
        this.transportationOptionId = transportationOptionId;
        return this;
    }

    @Schema(required=true, description="Identifier of a transportation option. A transportation option represent one option for how to send a shipment.")
    public String getTransportationOptionId() {
        return this.transportationOptionId;
    }

    public void setTransportationOptionId(String transportationOptionId) {
        this.transportationOptionId = transportationOptionId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TransportationOption transportationOption = (TransportationOption)o;
        return Objects.equals(this.carrier, transportationOption.carrier) && Objects.equals(this.carrierAppointment, transportationOption.carrierAppointment) && Objects.equals(this.preconditions, transportationOption.preconditions) && Objects.equals(this.quote, transportationOption.quote) && Objects.equals(this.shipmentId, transportationOption.shipmentId) && Objects.equals(this.shippingMode, transportationOption.shippingMode) && Objects.equals(this.shippingSolution, transportationOption.shippingSolution) && Objects.equals(this.transportationOptionId, transportationOption.transportationOptionId);
    }

    public int hashCode() {
        return Objects.hash(this.carrier, this.carrierAppointment, this.preconditions, this.quote, this.shipmentId, this.shippingMode, this.shippingSolution, this.transportationOptionId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TransportationOption {\n");
        sb.append("    carrier: ").append(this.toIndentedString(this.carrier)).append("\n");
        sb.append("    carrierAppointment: ").append(this.toIndentedString(this.carrierAppointment)).append("\n");
        sb.append("    preconditions: ").append(this.toIndentedString(this.preconditions)).append("\n");
        sb.append("    quote: ").append(this.toIndentedString(this.quote)).append("\n");
        sb.append("    shipmentId: ").append(this.toIndentedString(this.shipmentId)).append("\n");
        sb.append("    shippingMode: ").append(this.toIndentedString(this.shippingMode)).append("\n");
        sb.append("    shippingSolution: ").append(this.toIndentedString(this.shippingSolution)).append("\n");
        sb.append("    transportationOptionId: ").append(this.toIndentedString(this.transportationOptionId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

