/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.fulfillment.inbound.v2024_03_20;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;

@Schema(description="Small Parcel Delivery (SPD) tracking items input information.")
public class SpdTrackingItemInput {
    @SerializedName(value="boxId")
    private String boxId = null;
    @SerializedName(value="trackingId")
    private String trackingId = null;

    public SpdTrackingItemInput boxId(String boxId) {
        this.boxId = boxId;
        return this;
    }

    @Schema(required=true, description="The ID provided by Amazon that identifies a given box. This ID is comprised of the external shipment ID (which is generated after transportation has been confirmed) and the index of the box.")
    public String getBoxId() {
        return this.boxId;
    }

    public void setBoxId(String boxId) {
        this.boxId = boxId;
    }

    public SpdTrackingItemInput trackingId(String trackingId) {
        this.trackingId = trackingId;
        return this;
    }

    @Schema(required=true, description="The tracking Id associated with each box in a non-Amazon partnered Small Parcel Delivery (SPD) shipment. The seller must provide this information.")
    public String getTrackingId() {
        return this.trackingId;
    }

    public void setTrackingId(String trackingId) {
        this.trackingId = trackingId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SpdTrackingItemInput spdTrackingItemInput = (SpdTrackingItemInput)o;
        return Objects.equals(this.boxId, spdTrackingItemInput.boxId) && Objects.equals(this.trackingId, spdTrackingItemInput.trackingId);
    }

    public int hashCode() {
        return Objects.hash(this.boxId, this.trackingId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SpdTrackingItemInput {\n");
        sb.append("    boxId: ").append(this.toIndentedString(this.boxId)).append("\n");
        sb.append("    trackingId: ").append(this.toIndentedString(this.trackingId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

