/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.fulfillment.inbound.v2024_03_20;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;

@Schema(description="Contains information used to track and identify a Small Parcel Delivery (SPD) item.")
public class SpdTrackingItem {
    @SerializedName(value="boxId")
    private String boxId = null;
    @SerializedName(value="trackingId")
    private String trackingId = null;
    @SerializedName(value="trackingNumberValidationStatus")
    private String trackingNumberValidationStatus = null;

    public SpdTrackingItem boxId(String boxId) {
        this.boxId = boxId;
        return this;
    }

    @Schema(description="The ID provided by Amazon that identifies a given box. This ID is comprised of the external shipment ID (which is generated after transportation has been confirmed) and the index of the box.")
    public String getBoxId() {
        return this.boxId;
    }

    public void setBoxId(String boxId) {
        this.boxId = boxId;
    }

    public SpdTrackingItem trackingId(String trackingId) {
        this.trackingId = trackingId;
        return this;
    }

    @Schema(description="The tracking ID associated with each box in a non-Amazon partnered Small Parcel Delivery (SPD) shipment.")
    public String getTrackingId() {
        return this.trackingId;
    }

    public void setTrackingId(String trackingId) {
        this.trackingId = trackingId;
    }

    public SpdTrackingItem trackingNumberValidationStatus(String trackingNumberValidationStatus) {
        this.trackingNumberValidationStatus = trackingNumberValidationStatus;
        return this;
    }

    @Schema(description="Indicates whether Amazon has validated the tracking number. Because shipment validation is asynchronous, tracking IDs might not be validated immediately, and the status might change after a few hours. If more than 24 hours have passed and the status is not yet 'VALIDATED' or `NOT_SUPPORTED`, verify the number and update it if necessary. **Possible values:** `VALIDATED`, `NOT_VALIDATED`, `NOT_SUPPORTED` (Amazon is unable to find tracking information for the provided tracking ID).")
    public String getTrackingNumberValidationStatus() {
        return this.trackingNumberValidationStatus;
    }

    public void setTrackingNumberValidationStatus(String trackingNumberValidationStatus) {
        this.trackingNumberValidationStatus = trackingNumberValidationStatus;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SpdTrackingItem spdTrackingItem = (SpdTrackingItem)o;
        return Objects.equals(this.boxId, spdTrackingItem.boxId) && Objects.equals(this.trackingId, spdTrackingItem.trackingId) && Objects.equals(this.trackingNumberValidationStatus, spdTrackingItem.trackingNumberValidationStatus);
    }

    public int hashCode() {
        return Objects.hash(this.boxId, this.trackingId, this.trackingNumberValidationStatus);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SpdTrackingItem {\n");
        sb.append("    boxId: ").append(this.toIndentedString(this.boxId)).append("\n");
        sb.append("    trackingId: ").append(this.toIndentedString(this.trackingId)).append("\n");
        sb.append("    trackingNumberValidationStatus: ").append(this.toIndentedString(this.trackingNumberValidationStatus)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

