/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.fulfillment.inbound.v2024_03_20;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

@Schema(description="The possible shipping modes for the packing option for a given shipping solution or program. Available solutions are Amazon-Partnered Carrier and Use Your Own Carrier. Available modes are ground small parcel, freight less-than-truckload (LTL), freight full-truckload (FTL) palletized, freight FTL non-palletized, ocean less-than-container-load (LCL), ocean full-container load (FCL), air small parcel, and air small parcel express.")
public class ShippingRequirements {
    @SerializedName(value="modes")
    private List<String> modes = new ArrayList<String>();
    @SerializedName(value="solution")
    private String solution = null;

    public ShippingRequirements modes(List<String> modes) {
        this.modes = modes;
        return this;
    }

    public ShippingRequirements addModesItem(String modesItem) {
        this.modes.add(modesItem);
        return this;
    }

    @Schema(required=true, description="Available shipment modes for this shipping program.")
    public List<String> getModes() {
        return this.modes;
    }

    public void setModes(List<String> modes) {
        this.modes = modes;
    }

    public ShippingRequirements solution(String solution) {
        this.solution = solution;
        return this;
    }

    @Schema(required=true, description="Shipping program for the option. Can be: `AMAZON_PARTNERED_CARRIER`, `USE_YOUR_OWN_CARRIER`.")
    public String getSolution() {
        return this.solution;
    }

    public void setSolution(String solution) {
        this.solution = solution;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ShippingRequirements shippingRequirements = (ShippingRequirements)o;
        return Objects.equals(this.modes, shippingRequirements.modes) && Objects.equals(this.solution, shippingRequirements.solution);
    }

    public int hashCode() {
        return Objects.hash(this.modes, this.solution);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ShippingRequirements {\n");
        sb.append("    modes: ").append(this.toIndentedString(this.modes)).append("\n");
        sb.append("    solution: ").append(this.toIndentedString(this.solution)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

