/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.fulfillment.inbound.v2024_03_20;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import software.amazon.spapi.models.fulfillment.inbound.v2024_03_20.ContactInformation;
import software.amazon.spapi.models.fulfillment.inbound.v2024_03_20.FreightInformation;
import software.amazon.spapi.models.fulfillment.inbound.v2024_03_20.PalletInput;
import software.amazon.spapi.models.fulfillment.inbound.v2024_03_20.WindowInput;

@Schema(description="Details needed to generate the transportation options.")
public class ShipmentTransportationConfiguration {
    @SerializedName(value="contactInformation")
    private ContactInformation contactInformation = null;
    @SerializedName(value="freightInformation")
    private FreightInformation freightInformation = null;
    @SerializedName(value="pallets")
    private List<PalletInput> pallets = null;
    @SerializedName(value="readyToShipWindow")
    private WindowInput readyToShipWindow = null;
    @SerializedName(value="shipmentId")
    private String shipmentId = null;

    public ShipmentTransportationConfiguration contactInformation(ContactInformation contactInformation) {
        this.contactInformation = contactInformation;
        return this;
    }

    @Schema(description="")
    public ContactInformation getContactInformation() {
        return this.contactInformation;
    }

    public void setContactInformation(ContactInformation contactInformation) {
        this.contactInformation = contactInformation;
    }

    public ShipmentTransportationConfiguration freightInformation(FreightInformation freightInformation) {
        this.freightInformation = freightInformation;
        return this;
    }

    @Schema(description="")
    public FreightInformation getFreightInformation() {
        return this.freightInformation;
    }

    public void setFreightInformation(FreightInformation freightInformation) {
        this.freightInformation = freightInformation;
    }

    public ShipmentTransportationConfiguration pallets(List<PalletInput> pallets) {
        this.pallets = pallets;
        return this;
    }

    public ShipmentTransportationConfiguration addPalletsItem(PalletInput palletsItem) {
        if (this.pallets == null) {
            this.pallets = new ArrayList<PalletInput>();
        }
        this.pallets.add(palletsItem);
        return this;
    }

    @Schema(description="List of pallet configuration inputs.")
    public List<PalletInput> getPallets() {
        return this.pallets;
    }

    public void setPallets(List<PalletInput> pallets) {
        this.pallets = pallets;
    }

    public ShipmentTransportationConfiguration readyToShipWindow(WindowInput readyToShipWindow) {
        this.readyToShipWindow = readyToShipWindow;
        return this;
    }

    @Schema(required=true, description="")
    public WindowInput getReadyToShipWindow() {
        return this.readyToShipWindow;
    }

    public void setReadyToShipWindow(WindowInput readyToShipWindow) {
        this.readyToShipWindow = readyToShipWindow;
    }

    public ShipmentTransportationConfiguration shipmentId(String shipmentId) {
        this.shipmentId = shipmentId;
        return this;
    }

    @Schema(required=true, description="Identifier of a shipment. A shipment contains the boxes and units being inbounded.")
    public String getShipmentId() {
        return this.shipmentId;
    }

    public void setShipmentId(String shipmentId) {
        this.shipmentId = shipmentId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ShipmentTransportationConfiguration shipmentTransportationConfiguration = (ShipmentTransportationConfiguration)o;
        return Objects.equals(this.contactInformation, shipmentTransportationConfiguration.contactInformation) && Objects.equals(this.freightInformation, shipmentTransportationConfiguration.freightInformation) && Objects.equals(this.pallets, shipmentTransportationConfiguration.pallets) && Objects.equals(this.readyToShipWindow, shipmentTransportationConfiguration.readyToShipWindow) && Objects.equals(this.shipmentId, shipmentTransportationConfiguration.shipmentId);
    }

    public int hashCode() {
        return Objects.hash(this.contactInformation, this.freightInformation, this.pallets, this.readyToShipWindow, this.shipmentId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ShipmentTransportationConfiguration {\n");
        sb.append("    contactInformation: ").append(this.toIndentedString(this.contactInformation)).append("\n");
        sb.append("    freightInformation: ").append(this.toIndentedString(this.freightInformation)).append("\n");
        sb.append("    pallets: ").append(this.toIndentedString(this.pallets)).append("\n");
        sb.append("    readyToShipWindow: ").append(this.toIndentedString(this.readyToShipWindow)).append("\n");
        sb.append("    shipmentId: ").append(this.toIndentedString(this.shipmentId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

