/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.fulfillment.inbound.v2024_03_20;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;

@Schema(description="Summary information about a shipment.")
public class ShipmentSummary {
    @SerializedName(value="shipmentId")
    private String shipmentId = null;
    @SerializedName(value="status")
    private String status = null;

    public ShipmentSummary shipmentId(String shipmentId) {
        this.shipmentId = shipmentId;
        return this;
    }

    @Schema(required=true, description="Identifier of a shipment. A shipment contains the boxes and units being inbounded.")
    public String getShipmentId() {
        return this.shipmentId;
    }

    public void setShipmentId(String shipmentId) {
        this.shipmentId = shipmentId;
    }

    public ShipmentSummary status(String status) {
        this.status = status;
        return this;
    }

    @Schema(required=true, description="The status of a shipment. The state of the shipment will typically start as `UNCONFIRMED`, then transition to `WORKING` after a placement option has been confirmed, and then to `READY_TO_SHIP` once labels are generated.  Possible values: `ABANDONED`, `CANCELLED`, `CHECKED_IN`, `CLOSED`, `DELETED`, `DELIVERED`, `IN_TRANSIT`, `MIXED`, `READY_TO_SHIP`, `RECEIVING`, `SHIPPED`, `UNCONFIRMED`, `WORKING`")
    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ShipmentSummary shipmentSummary = (ShipmentSummary)o;
        return Objects.equals(this.shipmentId, shipmentSummary.shipmentId) && Objects.equals(this.status, shipmentSummary.status);
    }

    public int hashCode() {
        return Objects.hash(this.shipmentId, this.status);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ShipmentSummary {\n");
        sb.append("    shipmentId: ").append(this.toIndentedString(this.shipmentId)).append("\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

