/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.fulfillment.inbound.v2024_03_20;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import software.amazon.spapi.models.fulfillment.inbound.v2024_03_20.Address;

@Schema(description="Specifies the 'ship from' address for the shipment.")
public class ShipmentSource {
    @SerializedName(value="address")
    private Address address = null;
    @SerializedName(value="sourceType")
    private String sourceType = null;

    public ShipmentSource address(Address address) {
        this.address = address;
        return this;
    }

    @Schema(description="")
    public Address getAddress() {
        return this.address;
    }

    public void setAddress(Address address) {
        this.address = address;
    }

    public ShipmentSource sourceType(String sourceType) {
        this.sourceType = sourceType;
        return this;
    }

    @Schema(required=true, description="The type of source for this shipment. Possible values: `SELLER_FACILITY`.")
    public String getSourceType() {
        return this.sourceType;
    }

    public void setSourceType(String sourceType) {
        this.sourceType = sourceType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ShipmentSource shipmentSource = (ShipmentSource)o;
        return Objects.equals(this.address, shipmentSource.address) && Objects.equals(this.sourceType, shipmentSource.sourceType);
    }

    public int hashCode() {
        return Objects.hash(this.address, this.sourceType);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ShipmentSource {\n");
        sb.append("    address: ").append(this.toIndentedString(this.address)).append("\n");
        sb.append("    sourceType: ").append(this.toIndentedString(this.sourceType)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

