/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.fulfillment.inbound.v2024_03_20;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import software.amazon.spapi.models.fulfillment.inbound.v2024_03_20.Address;

@Schema(description="The Amazon fulfillment center address and warehouse ID.")
public class ShipmentDestination {
    @SerializedName(value="address")
    private Address address = null;
    @SerializedName(value="destinationType")
    private String destinationType = null;
    @SerializedName(value="warehouseId")
    private String warehouseId = null;

    public ShipmentDestination address(Address address) {
        this.address = address;
        return this;
    }

    @Schema(description="")
    public Address getAddress() {
        return this.address;
    }

    public void setAddress(Address address) {
        this.address = address;
    }

    public ShipmentDestination destinationType(String destinationType) {
        this.destinationType = destinationType;
        return this;
    }

    @Schema(required=true, description="The type of destination for this shipment. Possible values: `AMAZON_OPTIMIZED`, `AMAZON_WAREHOUSE`.")
    public String getDestinationType() {
        return this.destinationType;
    }

    public void setDestinationType(String destinationType) {
        this.destinationType = destinationType;
    }

    public ShipmentDestination warehouseId(String warehouseId) {
        this.warehouseId = warehouseId;
        return this;
    }

    @Schema(description="The warehouse that the shipment should be sent to. This can be empty if the destination type is `AMAZON_OPTIMIZED`.")
    public String getWarehouseId() {
        return this.warehouseId;
    }

    public void setWarehouseId(String warehouseId) {
        this.warehouseId = warehouseId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ShipmentDestination shipmentDestination = (ShipmentDestination)o;
        return Objects.equals(this.address, shipmentDestination.address) && Objects.equals(this.destinationType, shipmentDestination.destinationType) && Objects.equals(this.warehouseId, shipmentDestination.warehouseId);
    }

    public int hashCode() {
        return Objects.hash(this.address, this.destinationType, this.warehouseId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class ShipmentDestination {\n");
        sb.append("    address: ").append(this.toIndentedString(this.address)).append("\n");
        sb.append("    destinationType: ").append(this.toIndentedString(this.destinationType)).append("\n");
        sb.append("    warehouseId: ").append(this.toIndentedString(this.warehouseId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

