/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.fulfillment.inbound.v2024_03_20;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import software.amazon.spapi.models.fulfillment.inbound.v2024_03_20.ContactInformation;
import software.amazon.spapi.models.fulfillment.inbound.v2024_03_20.Dates;
import software.amazon.spapi.models.fulfillment.inbound.v2024_03_20.FreightInformation;
import software.amazon.spapi.models.fulfillment.inbound.v2024_03_20.SelectedDeliveryWindow;
import software.amazon.spapi.models.fulfillment.inbound.v2024_03_20.SelfShipAppointmentDetails;
import software.amazon.spapi.models.fulfillment.inbound.v2024_03_20.ShipmentDestination;
import software.amazon.spapi.models.fulfillment.inbound.v2024_03_20.ShipmentSource;
import software.amazon.spapi.models.fulfillment.inbound.v2024_03_20.TrackingDetails;

@Schema(description="Contains information pertaining to a shipment in an inbound plan.")
public class Shipment {
    @SerializedName(value="amazonReferenceId")
    private String amazonReferenceId = null;
    @SerializedName(value="contactInformation")
    private ContactInformation contactInformation = null;
    @SerializedName(value="dates")
    private Dates dates = null;
    @SerializedName(value="destination")
    private ShipmentDestination destination = null;
    @SerializedName(value="freightInformation")
    private FreightInformation freightInformation = null;
    @SerializedName(value="name")
    private String name = null;
    @SerializedName(value="placementOptionId")
    private String placementOptionId = null;
    @SerializedName(value="selectedDeliveryWindow")
    private SelectedDeliveryWindow selectedDeliveryWindow = null;
    @SerializedName(value="selectedTransportationOptionId")
    private String selectedTransportationOptionId = null;
    @SerializedName(value="selfShipAppointmentDetails")
    private List<SelfShipAppointmentDetails> selfShipAppointmentDetails = null;
    @SerializedName(value="shipmentConfirmationId")
    private String shipmentConfirmationId = null;
    @SerializedName(value="shipmentId")
    private String shipmentId = null;
    @SerializedName(value="source")
    private ShipmentSource source = null;
    @SerializedName(value="status")
    private String status = null;
    @SerializedName(value="trackingDetails")
    private TrackingDetails trackingDetails = null;

    public Shipment amazonReferenceId(String amazonReferenceId) {
        this.amazonReferenceId = amazonReferenceId;
        return this;
    }

    @Schema(description="A unique identifier created by Amazon that identifies this Amazon-partnered, Less Than Truckload/Full Truckload (LTL/FTL) shipment.")
    public String getAmazonReferenceId() {
        return this.amazonReferenceId;
    }

    public void setAmazonReferenceId(String amazonReferenceId) {
        this.amazonReferenceId = amazonReferenceId;
    }

    public Shipment contactInformation(ContactInformation contactInformation) {
        this.contactInformation = contactInformation;
        return this;
    }

    @Schema(description="")
    public ContactInformation getContactInformation() {
        return this.contactInformation;
    }

    public void setContactInformation(ContactInformation contactInformation) {
        this.contactInformation = contactInformation;
    }

    public Shipment dates(Dates dates) {
        this.dates = dates;
        return this;
    }

    @Schema(description="")
    public Dates getDates() {
        return this.dates;
    }

    public void setDates(Dates dates) {
        this.dates = dates;
    }

    public Shipment destination(ShipmentDestination destination) {
        this.destination = destination;
        return this;
    }

    @Schema(required=true, description="")
    public ShipmentDestination getDestination() {
        return this.destination;
    }

    public void setDestination(ShipmentDestination destination) {
        this.destination = destination;
    }

    public Shipment freightInformation(FreightInformation freightInformation) {
        this.freightInformation = freightInformation;
        return this;
    }

    @Schema(description="")
    public FreightInformation getFreightInformation() {
        return this.freightInformation;
    }

    public void setFreightInformation(FreightInformation freightInformation) {
        this.freightInformation = freightInformation;
    }

    public Shipment name(String name) {
        this.name = name;
        return this;
    }

    @Schema(description="The name of the shipment.")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Shipment placementOptionId(String placementOptionId) {
        this.placementOptionId = placementOptionId;
        return this;
    }

    @Schema(required=true, description="The identifier of a placement option. A placement option represents the shipment splits and destinations of SKUs.")
    public String getPlacementOptionId() {
        return this.placementOptionId;
    }

    public void setPlacementOptionId(String placementOptionId) {
        this.placementOptionId = placementOptionId;
    }

    public Shipment selectedDeliveryWindow(SelectedDeliveryWindow selectedDeliveryWindow) {
        this.selectedDeliveryWindow = selectedDeliveryWindow;
        return this;
    }

    @Schema(description="")
    public SelectedDeliveryWindow getSelectedDeliveryWindow() {
        return this.selectedDeliveryWindow;
    }

    public void setSelectedDeliveryWindow(SelectedDeliveryWindow selectedDeliveryWindow) {
        this.selectedDeliveryWindow = selectedDeliveryWindow;
    }

    public Shipment selectedTransportationOptionId(String selectedTransportationOptionId) {
        this.selectedTransportationOptionId = selectedTransportationOptionId;
        return this;
    }

    @Schema(description="Identifier of a transportation option. A transportation option represent one option for how to send a shipment.")
    public String getSelectedTransportationOptionId() {
        return this.selectedTransportationOptionId;
    }

    public void setSelectedTransportationOptionId(String selectedTransportationOptionId) {
        this.selectedTransportationOptionId = selectedTransportationOptionId;
    }

    public Shipment selfShipAppointmentDetails(List<SelfShipAppointmentDetails> selfShipAppointmentDetails) {
        this.selfShipAppointmentDetails = selfShipAppointmentDetails;
        return this;
    }

    public Shipment addSelfShipAppointmentDetailsItem(SelfShipAppointmentDetails selfShipAppointmentDetailsItem) {
        if (this.selfShipAppointmentDetails == null) {
            this.selfShipAppointmentDetails = new ArrayList<SelfShipAppointmentDetails>();
        }
        this.selfShipAppointmentDetails.add(selfShipAppointmentDetailsItem);
        return this;
    }

    @Schema(description="List of self ship appointment details.")
    public List<SelfShipAppointmentDetails> getSelfShipAppointmentDetails() {
        return this.selfShipAppointmentDetails;
    }

    public void setSelfShipAppointmentDetails(List<SelfShipAppointmentDetails> selfShipAppointmentDetails) {
        this.selfShipAppointmentDetails = selfShipAppointmentDetails;
    }

    public Shipment shipmentConfirmationId(String shipmentConfirmationId) {
        this.shipmentConfirmationId = shipmentConfirmationId;
        return this;
    }

    @Schema(description="The confirmed shipment ID which shows up on labels (for example, `FBA1234ABCD`).")
    public String getShipmentConfirmationId() {
        return this.shipmentConfirmationId;
    }

    public void setShipmentConfirmationId(String shipmentConfirmationId) {
        this.shipmentConfirmationId = shipmentConfirmationId;
    }

    public Shipment shipmentId(String shipmentId) {
        this.shipmentId = shipmentId;
        return this;
    }

    @Schema(required=true, description="Identifier of a shipment. A shipment contains the boxes and units being inbounded.")
    public String getShipmentId() {
        return this.shipmentId;
    }

    public void setShipmentId(String shipmentId) {
        this.shipmentId = shipmentId;
    }

    public Shipment source(ShipmentSource source) {
        this.source = source;
        return this;
    }

    @Schema(required=true, description="")
    public ShipmentSource getSource() {
        return this.source;
    }

    public void setSource(ShipmentSource source) {
        this.source = source;
    }

    public Shipment status(String status) {
        this.status = status;
        return this;
    }

    @Schema(description="The status of a shipment. The state of the shipment will typically start as `UNCONFIRMED`, then transition to `WORKING` after a placement option has been confirmed, and then to `READY_TO_SHIP` once labels are generated.  Possible values: `ABANDONED`, `CANCELLED`, `CHECKED_IN`, `CLOSED`, `DELETED`, `DELIVERED`, `IN_TRANSIT`, `MIXED`, `READY_TO_SHIP`, `RECEIVING`, `SHIPPED`, `UNCONFIRMED`, `WORKING`")
    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public Shipment trackingDetails(TrackingDetails trackingDetails) {
        this.trackingDetails = trackingDetails;
        return this;
    }

    @Schema(description="")
    public TrackingDetails getTrackingDetails() {
        return this.trackingDetails;
    }

    public void setTrackingDetails(TrackingDetails trackingDetails) {
        this.trackingDetails = trackingDetails;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Shipment shipment = (Shipment)o;
        return Objects.equals(this.amazonReferenceId, shipment.amazonReferenceId) && Objects.equals(this.contactInformation, shipment.contactInformation) && Objects.equals(this.dates, shipment.dates) && Objects.equals(this.destination, shipment.destination) && Objects.equals(this.freightInformation, shipment.freightInformation) && Objects.equals(this.name, shipment.name) && Objects.equals(this.placementOptionId, shipment.placementOptionId) && Objects.equals(this.selectedDeliveryWindow, shipment.selectedDeliveryWindow) && Objects.equals(this.selectedTransportationOptionId, shipment.selectedTransportationOptionId) && Objects.equals(this.selfShipAppointmentDetails, shipment.selfShipAppointmentDetails) && Objects.equals(this.shipmentConfirmationId, shipment.shipmentConfirmationId) && Objects.equals(this.shipmentId, shipment.shipmentId) && Objects.equals(this.source, shipment.source) && Objects.equals(this.status, shipment.status) && Objects.equals(this.trackingDetails, shipment.trackingDetails);
    }

    public int hashCode() {
        return Objects.hash(this.amazonReferenceId, this.contactInformation, this.dates, this.destination, this.freightInformation, this.name, this.placementOptionId, this.selectedDeliveryWindow, this.selectedTransportationOptionId, this.selfShipAppointmentDetails, this.shipmentConfirmationId, this.shipmentId, this.source, this.status, this.trackingDetails);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Shipment {\n");
        sb.append("    amazonReferenceId: ").append(this.toIndentedString(this.amazonReferenceId)).append("\n");
        sb.append("    contactInformation: ").append(this.toIndentedString(this.contactInformation)).append("\n");
        sb.append("    dates: ").append(this.toIndentedString(this.dates)).append("\n");
        sb.append("    destination: ").append(this.toIndentedString(this.destination)).append("\n");
        sb.append("    freightInformation: ").append(this.toIndentedString(this.freightInformation)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    placementOptionId: ").append(this.toIndentedString(this.placementOptionId)).append("\n");
        sb.append("    selectedDeliveryWindow: ").append(this.toIndentedString(this.selectedDeliveryWindow)).append("\n");
        sb.append("    selectedTransportationOptionId: ").append(this.toIndentedString(this.selectedTransportationOptionId)).append("\n");
        sb.append("    selfShipAppointmentDetails: ").append(this.toIndentedString(this.selfShipAppointmentDetails)).append("\n");
        sb.append("    shipmentConfirmationId: ").append(this.toIndentedString(this.shipmentConfirmationId)).append("\n");
        sb.append("    shipmentId: ").append(this.toIndentedString(this.shipmentId)).append("\n");
        sb.append("    source: ").append(this.toIndentedString(this.source)).append("\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("    trackingDetails: ").append(this.toIndentedString(this.trackingDetails)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

