/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.fulfillment.inbound.v2024_03_20;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import org.threeten.bp.OffsetDateTime;

@Schema(description="Selected delivery window attributes.")
public class SelectedDeliveryWindow {
    @SerializedName(value="availabilityType")
    private String availabilityType = null;
    @SerializedName(value="deliveryWindowOptionId")
    private String deliveryWindowOptionId = null;
    @SerializedName(value="editableUntil")
    private OffsetDateTime editableUntil = null;
    @SerializedName(value="endDate")
    private OffsetDateTime endDate = null;
    @SerializedName(value="startDate")
    private OffsetDateTime startDate = null;

    public SelectedDeliveryWindow availabilityType(String availabilityType) {
        this.availabilityType = availabilityType;
        return this;
    }

    @Schema(required=true, description="Identifies type of Delivery Window Availability. Values: `AVAILABLE`, `CONGESTED`")
    public String getAvailabilityType() {
        return this.availabilityType;
    }

    public void setAvailabilityType(String availabilityType) {
        this.availabilityType = availabilityType;
    }

    public SelectedDeliveryWindow deliveryWindowOptionId(String deliveryWindowOptionId) {
        this.deliveryWindowOptionId = deliveryWindowOptionId;
        return this;
    }

    @Schema(required=true, description="Identifier of a delivery window option. A delivery window option represent one option for when a shipment is expected to be delivered.")
    public String getDeliveryWindowOptionId() {
        return this.deliveryWindowOptionId;
    }

    public void setDeliveryWindowOptionId(String deliveryWindowOptionId) {
        this.deliveryWindowOptionId = deliveryWindowOptionId;
    }

    public SelectedDeliveryWindow editableUntil(OffsetDateTime editableUntil) {
        this.editableUntil = editableUntil;
        return this;
    }

    @Schema(description="The timestamp at which this Window can no longer be edited.")
    public OffsetDateTime getEditableUntil() {
        return this.editableUntil;
    }

    public void setEditableUntil(OffsetDateTime editableUntil) {
        this.editableUntil = editableUntil;
    }

    public SelectedDeliveryWindow endDate(OffsetDateTime endDate) {
        this.endDate = endDate;
        return this;
    }

    @Schema(required=true, description="The end timestamp of the window.")
    public OffsetDateTime getEndDate() {
        return this.endDate;
    }

    public void setEndDate(OffsetDateTime endDate) {
        this.endDate = endDate;
    }

    public SelectedDeliveryWindow startDate(OffsetDateTime startDate) {
        this.startDate = startDate;
        return this;
    }

    @Schema(required=true, description="The start timestamp of the window.")
    public OffsetDateTime getStartDate() {
        return this.startDate;
    }

    public void setStartDate(OffsetDateTime startDate) {
        this.startDate = startDate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SelectedDeliveryWindow selectedDeliveryWindow = (SelectedDeliveryWindow)o;
        return Objects.equals(this.availabilityType, selectedDeliveryWindow.availabilityType) && Objects.equals(this.deliveryWindowOptionId, selectedDeliveryWindow.deliveryWindowOptionId) && Objects.equals(this.editableUntil, selectedDeliveryWindow.editableUntil) && Objects.equals(this.endDate, selectedDeliveryWindow.endDate) && Objects.equals(this.startDate, selectedDeliveryWindow.startDate);
    }

    public int hashCode() {
        return Objects.hash(this.availabilityType, this.deliveryWindowOptionId, this.editableUntil, this.endDate, this.startDate);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class SelectedDeliveryWindow {\n");
        sb.append("    availabilityType: ").append(this.toIndentedString(this.availabilityType)).append("\n");
        sb.append("    deliveryWindowOptionId: ").append(this.toIndentedString(this.deliveryWindowOptionId)).append("\n");
        sb.append("    editableUntil: ").append(this.toIndentedString(this.editableUntil)).append("\n");
        sb.append("    endDate: ").append(this.toIndentedString(this.endDate)).append("\n");
        sb.append("    startDate: ").append(this.toIndentedString(this.startDate)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

