/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.fulfillment.inbound.v2024_03_20;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.threeten.bp.OffsetDateTime;
import software.amazon.spapi.models.fulfillment.inbound.v2024_03_20.Incentive;

@Schema(description="Contains information pertaining to the placement of the contents of an inbound plan and the related costs.")
public class PlacementOption {
    @SerializedName(value="discounts")
    private List<Incentive> discounts = new ArrayList<Incentive>();
    @SerializedName(value="expiration")
    private OffsetDateTime expiration = null;
    @SerializedName(value="fees")
    private List<Incentive> fees = new ArrayList<Incentive>();
    @SerializedName(value="placementOptionId")
    private String placementOptionId = null;
    @SerializedName(value="shipmentIds")
    private List<String> shipmentIds = new ArrayList<String>();
    @SerializedName(value="status")
    private String status = null;

    public PlacementOption discounts(List<Incentive> discounts) {
        this.discounts = discounts;
        return this;
    }

    public PlacementOption addDiscountsItem(Incentive discountsItem) {
        this.discounts.add(discountsItem);
        return this;
    }

    @Schema(required=true, description="Discount for the offered option.")
    public List<Incentive> getDiscounts() {
        return this.discounts;
    }

    public void setDiscounts(List<Incentive> discounts) {
        this.discounts = discounts;
    }

    public PlacementOption expiration(OffsetDateTime expiration) {
        this.expiration = expiration;
        return this;
    }

    @Schema(description="The expiration date of the placement option. In [ISO 8601](https://developer-docs.amazon.com/sp-api/docs/iso-8601) datetime format with pattern `yyyy-MM-ddTHH:mm:ss.sssZ`.")
    public OffsetDateTime getExpiration() {
        return this.expiration;
    }

    public void setExpiration(OffsetDateTime expiration) {
        this.expiration = expiration;
    }

    public PlacementOption fees(List<Incentive> fees) {
        this.fees = fees;
        return this;
    }

    public PlacementOption addFeesItem(Incentive feesItem) {
        this.fees.add(feesItem);
        return this;
    }

    @Schema(required=true, description="The fee for the offered option.")
    public List<Incentive> getFees() {
        return this.fees;
    }

    public void setFees(List<Incentive> fees) {
        this.fees = fees;
    }

    public PlacementOption placementOptionId(String placementOptionId) {
        this.placementOptionId = placementOptionId;
        return this;
    }

    @Schema(required=true, description="The identifier of a placement option. A placement option represents the shipment splits and destinations of SKUs.")
    public String getPlacementOptionId() {
        return this.placementOptionId;
    }

    public void setPlacementOptionId(String placementOptionId) {
        this.placementOptionId = placementOptionId;
    }

    public PlacementOption shipmentIds(List<String> shipmentIds) {
        this.shipmentIds = shipmentIds;
        return this;
    }

    public PlacementOption addShipmentIdsItem(String shipmentIdsItem) {
        this.shipmentIds.add(shipmentIdsItem);
        return this;
    }

    @Schema(required=true, description="Shipment ids.")
    public List<String> getShipmentIds() {
        return this.shipmentIds;
    }

    public void setShipmentIds(List<String> shipmentIds) {
        this.shipmentIds = shipmentIds;
    }

    public PlacementOption status(String status) {
        this.status = status;
        return this;
    }

    @Schema(required=true, description="The status of a placement option. Possible values: `OFFERED`, `ACCEPTED`, `EXPIRED`.")
    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PlacementOption placementOption = (PlacementOption)o;
        return Objects.equals(this.discounts, placementOption.discounts) && Objects.equals(this.expiration, placementOption.expiration) && Objects.equals(this.fees, placementOption.fees) && Objects.equals(this.placementOptionId, placementOption.placementOptionId) && Objects.equals(this.shipmentIds, placementOption.shipmentIds) && Objects.equals(this.status, placementOption.status);
    }

    public int hashCode() {
        return Objects.hash(this.discounts, this.expiration, this.fees, this.placementOptionId, this.shipmentIds, this.status);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class PlacementOption {\n");
        sb.append("    discounts: ").append(this.toIndentedString(this.discounts)).append("\n");
        sb.append("    expiration: ").append(this.toIndentedString(this.expiration)).append("\n");
        sb.append("    fees: ").append(this.toIndentedString(this.fees)).append("\n");
        sb.append("    placementOptionId: ").append(this.toIndentedString(this.placementOptionId)).append("\n");
        sb.append("    shipmentIds: ").append(this.toIndentedString(this.shipmentIds)).append("\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

