/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.spapi.models.fulfillment.inbound.v2024_03_20;

import com.google.gson.annotations.SerializedName;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;
import software.amazon.spapi.models.fulfillment.inbound.v2024_03_20.Dimensions;
import software.amazon.spapi.models.fulfillment.inbound.v2024_03_20.Stackability;
import software.amazon.spapi.models.fulfillment.inbound.v2024_03_20.Weight;

@Schema(description="Contains information about a pallet that is used in the inbound plan. The pallet is a container that holds multiple items or boxes.")
public class Pallet {
    @SerializedName(value="dimensions")
    private Dimensions dimensions = null;
    @SerializedName(value="packageId")
    private String packageId = null;
    @SerializedName(value="quantity")
    private Integer quantity = null;
    @SerializedName(value="stackability")
    private Stackability stackability = null;
    @SerializedName(value="weight")
    private Weight weight = null;

    public Pallet dimensions(Dimensions dimensions) {
        this.dimensions = dimensions;
        return this;
    }

    @Schema(description="")
    public Dimensions getDimensions() {
        return this.dimensions;
    }

    public void setDimensions(Dimensions dimensions) {
        this.dimensions = dimensions;
    }

    public Pallet packageId(String packageId) {
        this.packageId = packageId;
        return this;
    }

    @Schema(required=true, description="Primary key to uniquely identify a Package (Box or Pallet).")
    public String getPackageId() {
        return this.packageId;
    }

    public void setPackageId(String packageId) {
        this.packageId = packageId;
    }

    public Pallet quantity(Integer quantity) {
        this.quantity = quantity;
        return this;
    }

    @Schema(description="The number of containers where all other properties like weight or dimensions are identical.")
    public Integer getQuantity() {
        return this.quantity;
    }

    public void setQuantity(Integer quantity) {
        this.quantity = quantity;
    }

    public Pallet stackability(Stackability stackability) {
        this.stackability = stackability;
        return this;
    }

    @Schema(description="")
    public Stackability getStackability() {
        return this.stackability;
    }

    public void setStackability(Stackability stackability) {
        this.stackability = stackability;
    }

    public Pallet weight(Weight weight) {
        this.weight = weight;
        return this;
    }

    @Schema(description="")
    public Weight getWeight() {
        return this.weight;
    }

    public void setWeight(Weight weight) {
        this.weight = weight;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Pallet pallet = (Pallet)o;
        return Objects.equals(this.dimensions, pallet.dimensions) && Objects.equals(this.packageId, pallet.packageId) && Objects.equals(this.quantity, pallet.quantity) && Objects.equals((Object)this.stackability, (Object)pallet.stackability) && Objects.equals(this.weight, pallet.weight);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.dimensions, this.packageId, this.quantity, this.stackability, this.weight});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Pallet {\n");
        sb.append("    dimensions: ").append(this.toIndentedString(this.dimensions)).append("\n");
        sb.append("    packageId: ").append(this.toIndentedString(this.packageId)).append("\n");
        sb.append("    quantity: ").append(this.toIndentedString(this.quantity)).append("\n");
        sb.append("    stackability: ").append(this.toIndentedString((Object)this.stackability)).append("\n");
        sb.append("    weight: ").append(this.toIndentedString(this.weight)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

